/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ant;

import com.sshtools.ant.SshSubTask;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class Sftp
extends SshSubTask {
    protected static final int SEND_FILES = 0;
    protected static final int GET_FILES = 1;
    protected static final int DEL_FILES = 2;
    protected static final int MK_DIR = 4;
    protected static final int CHMOD = 5;
    protected static final String[] ACTION_STRS = new String[]{"Sending", "Getting", "Deleting", "Listing", "Making directory", "chmod"};
    protected static final String[] COMPLETED_ACTION_STRS = new String[]{"Sent", "Retrieved", "Deleted", "Listed", "Created directory", "Mode changed"};
    private String remotedir = ".";
    private boolean verbose = false;
    private boolean newerOnly = false;
    private int action = 0;
    private Vector filesets = new Vector();
    private Vector dirCache = new Vector();
    private int transferred = 0;
    private String remoteFileSep = "/";
    private boolean skipFailedTransfers = false;
    private int skipped = 0;
    private boolean ignoreNoncriticalErrors = false;
    private String chmod = "777";
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setRemotedir(String string) {
        this.remotedir = string;
    }

    public void setNewer(boolean bl) {
        this.newerOnly = bl;
    }

    public void setDepends(boolean bl) {
        this.newerOnly = bl;
    }

    public void setChmod(String string) {
        this.chmod = string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void setAction(Action action) throws BuildException {
        this.action = action.getAction();
    }

    public void setSkipFailedTransfers(boolean bl) {
        this.skipFailedTransfers = bl;
    }

    public void setIgnoreNoncriticalErrors(boolean bl) {
        this.ignoreNoncriticalErrors = bl;
    }

    protected void checkConfiguration() throws BuildException {
        if (this.action == 4 && this.remotedir == null) {
            throw new BuildException("remotedir attribute must be set for mkdir action!");
        }
        if (this.action == 5 && this.chmod == null) {
            throw new BuildException("chmod attribute must be set for chmod action!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int transferFiles(SftpClient sftpClient, FileSet fileSet) throws IOException, BuildException {
        DirectoryScanner directoryScanner;
        if (this.action == 0) {
            directoryScanner = fileSet.getDirectoryScanner(this.parent.getProject());
        } else {
            directoryScanner = new SftpDirectoryScanner(sftpClient);
            fileSet.setupDirectoryScanner((FileScanner)directoryScanner, this.parent.getProject());
            directoryScanner.scan();
        }
        String[] stringArray = directoryScanner.getIncludedFiles();
        String string = null;
        if (directoryScanner.getBasedir() == null && (this.action == 0 || this.action == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        if (this.action == 0 || this.action == 1) {
            string = directoryScanner.getBasedir().getAbsolutePath();
        }
        BufferedWriter bufferedWriter = null;
        try {
            block9: for (int i = 0; i < stringArray.length; ++i) {
                switch (this.action) {
                    case 0: {
                        this.sendFile(sftpClient, string, stringArray[i]);
                        continue block9;
                    }
                    case 1: {
                        this.getFile(sftpClient, string, stringArray[i]);
                        continue block9;
                    }
                    case 2: {
                        this.delFile(sftpClient, stringArray[i]);
                        continue block9;
                    }
                    case 5: {
                        this.chmod(sftpClient, stringArray[i]);
                        ++this.transferred;
                        continue block9;
                    }
                    default: {
                        throw new BuildException("unknown ftp action " + this.action);
                    }
                }
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        return stringArray.length;
    }

    protected void transferFiles(SftpClient sftpClient) throws IOException, BuildException {
        this.transferred = 0;
        this.skipped = 0;
        if (this.filesets.size() == 0) {
            throw new BuildException("at least one fileset must be specified.");
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(i);
            if (fileSet == null) continue;
            this.transferFiles(sftpClient, fileSet);
        }
        this.log(this.transferred + " files " + COMPLETED_ACTION_STRS[this.action]);
        if (this.skipped != 0) {
            this.log(this.skipped + " files were not successfully " + COMPLETED_ACTION_STRS[this.action]);
        }
    }

    protected String resolveFile(String string) {
        return string.replace(System.getProperty("file.separator").charAt(0), this.remoteFileSep.charAt(0));
    }

    protected void createParents(SftpClient sftpClient, String string) throws IOException, BuildException {
        String string2;
        Vector<File> vector = new Vector<File>();
        File file = new File(string);
        while ((string2 = file.getParent()) != null) {
            file = new File(string2);
            vector.addElement(file);
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            file = (File)vector.elementAt(i);
            if (this.dirCache.contains(file)) continue;
            this.log("creating remote directory " + this.resolveFile(file.getPath()), 3);
            try {
                sftpClient.mkdir(this.resolveFile(file.getPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dirCache.addElement(file);
        }
    }

    protected boolean isUpToDate(SftpClient sftpClient, File file, String string) throws IOException, BuildException {
        try {
            this.log("Checking date for " + string, 3);
            FileAttributes fileAttributes = sftpClient.stat(string);
            long l = fileAttributes.getModifiedTime().longValue() * 1000L;
            long l2 = file.lastModified();
            if (this.action == 0) {
                return l > l2;
            }
            return l2 > l;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFile(SftpClient sftpClient, String string, String string2) throws IOException, BuildException {
        block27: {
            String string3;
            InputStream inputStream = null;
            Object var5_5 = null;
            try {
                File file = this.parent.getProject().resolveFile(new File(string, string2).getPath());
                string3 = this.resolveFile(string2);
                if (this.newerOnly && this.isUpToDate(sftpClient, file, string3)) {
                    return;
                }
                if (this.verbose) {
                    this.log("transferring " + file.getAbsolutePath() + " to " + this.remotedir + string3);
                }
                inputStream = new BufferedInputStream(new FileInputStream(file));
                this.createParents(sftpClient, string2);
                sftpClient.put(file.getAbsolutePath(), string3);
                sftpClient.chmod(Integer.parseInt(this.chmod, 8), string3);
                this.log("File " + file.getAbsolutePath() + " copied to " + this.parent.host, 3);
                ++this.transferred;
            }
            catch (IOException iOException) {
                string3 = "Could not put file: " + iOException.getMessage();
                if (this.skipFailedTransfers) {
                    this.log(string3, 1);
                    ++this.skipped;
                    break block27;
                }
                throw new BuildException(string3);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (var5_5 != null) {
                        var5_5.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void delFile(SftpClient sftpClient, String string) throws IOException, BuildException {
        if (this.verbose) {
            this.log("deleting " + string);
        }
        try {
            String string2 = this.resolveFile(string);
            sftpClient.rm(string2);
            this.log("File " + string + " deleted from " + this.parent.host, 3);
            ++this.transferred;
        }
        catch (IOException iOException) {
            String string3 = "could not delete file: " + iOException.getMessage();
            if (this.skipFailedTransfers) {
                this.log(string3, 1);
                ++this.skipped;
            }
            throw new BuildException(string3);
        }
    }

    protected void chmod(SftpClient sftpClient, String string) throws IOException, BuildException {
        sftpClient.chmod(Integer.parseInt(this.chmod, 8), this.resolveFile(string));
    }

    protected void getFile(SftpClient sftpClient, String string, String string2) throws IOException, BuildException {
        try {
            File file;
            String string3 = string2;
            if (string3.indexOf("/") >= 0) {
                string3 = string3.substring(string2.lastIndexOf("/"));
            }
            File file2 = this.parent.getProject().resolveFile(new File(string, string3).getAbsolutePath());
            this.log(string);
            this.log(string2);
            this.log(file2.getAbsolutePath());
            if (this.newerOnly && this.isUpToDate(sftpClient, file2, this.resolveFile(string2))) {
                return;
            }
            if (this.verbose) {
                this.log("transferring " + string2 + " to " + file2.getAbsolutePath());
            }
            if (!(file = this.fileUtils.getParentFile(file2)).exists()) {
                file.mkdirs();
            }
            sftpClient.get(string2, file2.getAbsolutePath());
            if (this.verbose) {
                this.log("File " + file2.getAbsolutePath() + " copied from " + this.parent.host);
            }
            FileAttributes fileAttributes = sftpClient.stat(string2);
            file2.setLastModified(fileAttributes.getModifiedTime().longValue() * 1000L);
            ++this.transferred;
        }
        catch (IOException iOException) {
            String string4 = "could not get file: " + iOException.getMessage();
            if (this.skipFailedTransfers) {
                this.log(string4, 1);
                ++this.skipped;
            }
            throw new BuildException(string4);
        }
    }

    protected void makeRemoteDir(SftpClient sftpClient, String string) throws BuildException {
        if (this.verbose) {
            this.log("creating directory: " + string);
        }
        try {
            sftpClient.mkdir(string);
        }
        catch (IOException iOException) {
            this.log(iOException.getMessage());
        }
    }

    public void execute(SshClient sshClient) throws BuildException {
        try {
            Integer.parseInt(this.chmod, 8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("chmod attribute format is incorrect, use octal number format i.e 0777");
        }
        this.executeSFTPTask(sshClient);
    }

    protected void executeSFTPTask(SshClient sshClient) throws BuildException {
        SftpClient sftpClient = null;
        try {
            sftpClient = sshClient.openSftpClient();
            if (this.action == 4) {
                this.makeRemoteDir(sftpClient, this.remotedir);
            } else {
                if (this.remotedir.trim().length() > 0) {
                    this.log("Setting the remote directory ");
                    sftpClient.cd(this.remotedir);
                }
                this.remotedir = sftpClient.pwd();
                this.log("Remote directory is " + this.remotedir);
                if (!this.remotedir.endsWith("/")) {
                    this.remotedir = this.remotedir + "/";
                }
                this.log(ACTION_STRS[this.action] + " files");
                this.transferFiles(sftpClient);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("error during SFTP transfer: " + iOException);
        }
        finally {
            if (sftpClient != null && !sftpClient.isClosed()) {
                try {
                    this.log("Quiting SFTP", 3);
                    sftpClient.quit();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class Action
    extends EnumeratedAttribute {
        private static final String[] validActions = new String[]{"send", "put", "recv", "get", "del", "delete", "list", "mkdir", "chmod"};

        public String[] getValues() {
            return validActions;
        }

        public int getAction() {
            String string = this.getValue().toLowerCase(Locale.US);
            if (string.equals("send") || string.equals("put")) {
                return 0;
            }
            if (string.equals("recv") || string.equals("get")) {
                return 1;
            }
            if (string.equals("del") || string.equals("delete")) {
                return 2;
            }
            if (string.equals("chmod")) {
                return 5;
            }
            if (string.equals("mkdir")) {
                return 4;
            }
            return 0;
        }
    }

    protected class SftpDirectoryScanner
    extends DirectoryScanner {
        protected SftpClient sftp = null;

        public SftpDirectoryScanner(SftpClient sftpClient) {
            this.sftp = sftpClient;
        }

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new Vector();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new Vector();
            this.dirsIncluded = new Vector();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new Vector();
            this.scandir(Sftp.this.remotedir, true);
        }

        protected void scandir(String string, boolean bl) {
            try {
                List list = this.sftp.ls(string);
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    SftpFile sftpFile = (SftpFile)iterator.next();
                    if (sftpFile.getFilename().equals(".") || sftpFile.getFilename().equals("..")) continue;
                    if (sftpFile.isDirectory()) {
                        string2 = string + sftpFile.getFilename();
                        if (this.isIncluded(string2)) {
                            if (!this.isExcluded(string2)) {
                                this.dirsIncluded.addElement(string2);
                                if (bl) {
                                    this.scandir(string + sftpFile.getFilename(), bl);
                                }
                            } else {
                                this.dirsExcluded.addElement(string2);
                                if (bl && this.couldHoldIncluded(string2)) {
                                    this.scandir(string + sftpFile.getFilename(), bl);
                                }
                            }
                        } else {
                            this.dirsNotIncluded.addElement(string2);
                            if (bl && this.couldHoldIncluded(string2)) {
                                this.scandir(string + sftpFile.getFilename(), bl);
                            }
                        }
                        if (bl) continue;
                        this.scandir(string + sftpFile.getFilename(), bl);
                        continue;
                    }
                    if (!sftpFile.isFile()) continue;
                    string2 = string + sftpFile.getFilename();
                    if (this.isIncluded(string2)) {
                        if (!this.isExcluded(string2)) {
                            this.filesIncluded.addElement(string2);
                            continue;
                        }
                        this.filesExcluded.addElement(string2);
                        continue;
                    }
                    this.filesNotIncluded.addElement(string2);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Error while communicating with SFTP ", (Throwable)iOException);
            }
        }
    }
}

