/* sshdos.c       Copyright (c) 2000 Nagy Daniel
 *
 * $Date: 2001/02/22 09:53:17 $
 * $Revision: 1.3 $
 *
 * This module is the main part:
 *  - command line parsing
 *  - client loop
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <io.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdarg.h> 

#ifdef __DJGPP__
#include "include/tcp_djgp.h"
#elif __TURBOC__
#include "include/tcp.h"
#endif

#include "include/ssh.h"
#include "include/des.h"
#include "include/blowfish.h"
#include "include/version.h"
#include "include/protocol.h"
#include "include/vt100.h"

extern int connectssh(void);

extern char privileged;

char debug=0;
char verbose=0;
FILE *fileptr;
int cipher=0;				/* cipher of or off*/
int cipher_type=SSH_CIPHER_3DES;	/* type of cipher */

unsigned char *inbuf;  /* buffer for incoming raw packet */

struct Packet pktin = { 0, 0, 0, NULL, 0 };
struct Packet pktout = { 0, 0, 0, NULL, 0 };

tcp_Socket s;		/* socket */
int status;		/* status of communication */
unsigned char *username=NULL;
char *remotehost;
char *term="ansi"; /* terminal type */
int ssh_port=22;
char command[512];
char tty=0;
char statusline=1;

/* fatal error handler */
void fatal(const char *fmt, ...)
{
va_list ap;
char buf[1024];

  va_start(ap, fmt);
  vsprintf(buf, fmt, ap);
  va_end(ap);
  fprintf(stderr, "%s\n", buf);
  if( (debug) && (fileptr!=NULL) ) fclose(fileptr);
  if(inbuf!=NULL) free(inbuf);
  sock_close(&s);
  exit(255);
}



/* allocate a pseudo terminal */
void request_pty(char *termtype)
{
int i, len;

        i = strlen(termtype);
	s_wrpkt_start(10, i+5*4+1);
        pktout.body[0] = (i >> 24) & 0xFF;
        pktout.body[1] = (i >> 16) & 0xFF;
        pktout.body[2] = (i >> 8) & 0xFF;
        pktout.body[3] = i & 0xFF;
	memcpy(pktout.body+4, termtype, i);
        memset(pktout.body+4+i, 0, 17);
        pktout.body[7+i]=24;
        pktout.body[11+i]=80;
	s_wrpkt();
}

/* start interactive shell or run command */
void start_shell(void)
{
int len;

    if (command != 0 && command[0] != '\0') {
	s_wrpkt_start(13, (len = strlen(command)) + 4);
	pktout.body[0] = pktout.body[1] = 0;
	pktout.body[2] = (len >> 8) & 0xFF;
	pktout.body[3] = len & 0xFF;		/* up to 32k of string */
	memcpy(pktout.body+4, command, len);
	s_wrpkt();
    } else {
	s_wrpkt_start(12, 0);
	s_wrpkt();
    }
}


/* Client loop. This runs until SSH connection is terminated */
int dosession(void)
{
int len,i;

        while (ConChk())
		DoKey();

	sock_tick(&s, &status); /* TCP wait */
	len=sock_fastread(&s,inbuf,4); /* Read some data */
	if(!len) return(0); /* Begin loop again if none */
	for (i = len = 0; i < 4; i++) len = (len << 8) + inbuf[i]; /* Get packet size */
	sock_read(&s,inbuf+4,len + 8 - (len%8)); /* Read it */
	ssh_gotdata(inbuf); /* uncrypt and get valuable data */

	switch(pktin.type) {
		case SSH_SMSG_STDOUT_DATA:
			{
			for (i = 0; i < pktin.length-5; i++)
                        if (tty) ConOut(pktin.body[i+4]);
			else putchar(pktin.body[i+4]);
			break;
			}
		case SSH_SMSG_STDERR_DATA:
			{
			for (i = 0; i < pktin.length-5; i++)
			ConOut(pktin.body[i+4]);
			break;
			}
		case SSH_SMSG_EXITSTATUS:
			{
			s_wrpkt_start(SSH_CMSG_EXIT_CONFIRMATION,0);
			s_wrpkt();
	                return(EXIT_SSH);
			}
		case SSH_MSG_DISCONNECT:
			{
			 /* Connection reset by other party */
			pktin.body[pktin.length+4]=0;
			cputs(pktin.body+4);
			return(EXIT_SSH);
			}
		case	SSH_SMSG_SUCCESS:
		case	SSH_MSG_IGNORE:
			break;
		default:
			{
			cprintf("Unsupported packet received. Type: %d\n\r",pktin.type);
			return(0);
			}
		}
return(0);

sock_err:
  switch (status)
  {
    case 1 : cputs ("Connection closed\n\r");
             break;
    case -1: cputs ("REMOTE HOST CLOSED CONNECTION\n\r");
             break;
  }
  return(EXIT_SSH);

}


/* Get command line arguments */

void getargs(int argc, char *argv[])
{
int i, j, len;
char *s;
char *usage="Usage: sshdos [options] username remotehost [command [args]]\n"
	    "Options:\n"
	    "-c <3des|blowfish>     - cipher type\n"
	    "-t <ansi|vt100|linux>  - terminal type\n"
	    "-p <port number>       - remote port\n"
	    "-P                     - use non privileged local port\n"
            "-S                     - disable status line\n"
	    "-d                     - save SSH packets to debug.pkt\n"
	    "-v                     - verbose output\n"
	    "Default is 3des cipher and ansi terminal emulation.";

    for (i = 1; i < argc; ++i)
    {
	s = argv[i];
	if (*s != '-') break;
	switch (*++s)
	{
	case '\0':
	    fatal(usage);
	    return;

	case 'c':
	    if (*++s)
		{
		 if(!strcmp(s,"3des")) cipher_type = SSH_CIPHER_3DES;
		 else if(!strcmp(s,"blowfish")) cipher_type = SSH_CIPHER_BLOWFISH;
		 else fatal(usage);
		}
	    else if (++i < argc)
		{
		if(!strcmp(argv[i],"3des")) cipher_type = SSH_CIPHER_3DES;
		else if(!strcmp(argv[i],"blowfish")) cipher_type = SSH_CIPHER_BLOWFISH;
		else fatal(usage);
		}
	    else
		fatal(usage);
	    continue;

	case 't':
	    if (*++s)
		{
		 if(!strcmp(s,"ansi") || !strcmp(s,"vt100")
				|| !strcmp(s,"linux")) term = s;
		 else fatal(usage);
		}
	    else if (++i < argc)
		{
		 if(!strcmp(argv[i],"ansi") || !strcmp(argv[i],"vt100")
				|| !strcmp(argv[i],"linux")) term = argv[i];
		 else fatal(usage);
		}
	    else
		fatal(usage);
	    continue;

	case 'p':
	    if (*++s)
		 ssh_port = atoi(s);
	    else if (++i < argc)
		ssh_port = atoi(argv[i]);
	    else
		fatal(usage);
	    continue;

	case 'P':
	    privileged=0;
	    continue;

        case 'S':
            statusline = 0;
            continue;

	case 'd':
	    debug=1;
	    continue;

	case 'v':
	    verbose=1;
	    continue;

	default:
	    fatal(usage);
	} /* end switch */

    }

no_more_options:;
    if (i + 2 > argc) fatal(usage);
    username = argv[i++];
    remotehost = argv[i++];
    if (i >= argc)			/* command args? */
	return;
    /* collect remaining arguments and make a command line of them */
    for (len = 0, j = i; j < argc; j++)
	len += strlen(argv[j]) + 1;	/* 1 for the separating space */
    for (command[0] = '\0', j = i; j < argc; j++) {
	strcat(command, argv[j]);	/* inefficient, but no big deal */
	if (j < argc - 1)		/* last argument? */
            strcat(command, " ");
    }
#if	0
    printf("command: %s\n", command);
#endif
}



/* main program */
int main(int argc, char **argv)
{
int i, ch;

    cprintf("SSHDOS v%s\n\r", SSH_VERSION);

    if((inbuf=malloc(INBUF_SIZE))==NULL) fatal("Not enough memory");

    getargs(argc, argv);

/* Initalizations */

    srand (time(NULL)); /* Initialize random number generator */

    if(debug) if((fileptr=fopen("debug.pkt","w+"))==NULL)
			 fatal("Cannot create debug file");
	      else fputs("\n-------------------\n",fileptr);

    if(connectssh()) fatal("Connection error"); /* Connect to remote server */

    /* Request a pseudo terminal if stdout is the terminal*/

    if (isatty(fileno(stdout)))
        {
	tty=1;
        request_pty(term);
        packet_read_expect(SSH_SMSG_SUCCESS);
        }

    /* Start an interactive shell */
    start_shell();

#ifdef __DJGPP__
    tcp_cbreak(1);	/* No Break checking under DJGPP */
#endif
    KeyInit(); /* Initialize VT100 module */
    VidInit();
    VTInit();

/* Loop until session end */
   while(EXIT_SSH!=dosession());

/* Close TCP socket */

free(inbuf);
if(debug) fclose(fileptr);
sock_close(&s);
return(0);

sock_err:
  switch (status)
  {
    case 1 : cputs ("Connection closed\n\r");
             break;
    case -1: cputs ("REMOTE HOST CLOSED CONNECTION\n\r");
             break;
  }
  if( (debug) && (fileptr!=NULL) ) fclose(fileptr);
  if(inbuf!=NULL) free(inbuf);  return(1);
}

