#
#   DJGPP makefile for SSHDOS
#

HDRS          = ssh.h

# remove -DCOLOR for B&W mode
CFLAGS	      = -O -DCOLOR

LDFLAGS	      =

LIBS	      = lib/libwatt.a lib/libvt100.a lib/libssh.a lib/libcrypt.a

LINKER	      = gcc

OBJS=		sshdos.o \
		scpdos.o \
		negotiat.o \
		protocol.o \
		sshmd5.o \
		sshdes.o \
		sshblowf.o \
		sshcrc.o \
		sshrsa.o \
		vttio.o \
		vidio.o \
		keyio.o

SRCS=		sshdos.c \
		scpdos.c \
		negotiat.c \
		protocol.c \
		sshmd5.c \
		sshdes.c \
		sshblowf.c \
		sshcrc.c \
		sshrsa.c \
		vttio.c \
		vidio.c \
		keyio.c

all:		sshd386.exe scpd386.exe

sshd386.exe:	$(OBJS) $(LIBS)
		@echo "Linking sshd386 ... "
		@$(LINKER) $(LDFLAGS) -o sshd386 sshdos.o $(LIBS)
		@echo "done"

scpd386.exe:	$(OBJS) $(LIBS)
		@echo "Linking scpd386 ... "
		@$(LINKER) $(LDFLAGS) -o scpd386 scpdos.o $(LIBS)
		@echo "done"

lib/libvt100.a:	vttio.o vidio.o keyio.o
		ar rvs lib/libvt100.a vttio.o vidio.o keyio.o

lib/libssh.a:	negotiat.o protocol.o
		ar rvs lib/libssh.a negotiat.o protocol.o

lib/libcrypt.a:	sshcrc.o sshrsa.o sshblowf.o sshdes.o sshmd5.o
		ar rvs lib/libcrypt.a sshcrc.o sshrsa.o sshblowf.o sshdes.o sshmd5.o

clean:
		del *.o
		del sshd386
		del sshd386.exe
		del scpd386
		del scpd386.exe
		del lib\libvt100.a
		del lib\libssh.a
		del lib\libcrypt.a

###
sshdos.o: include/ssh.h
scpdos.o: include/ssh.h
negotiat.o: include/ssh.h
protocol.o: include/ssh.h
sshmd5.o: include/md5.h
sshdes.o: include/des.h
sshblowf.o: include/blowfish.h
sshcrc.o: 
sshrsa.o: include/rsa.h
vttio.o: 
vidio.o: 
keyio.o: 
