/* scpdos.c       Copyright (c) 2000 Nagy Daniel
 *
 * $Date: 2001/04/02 13:27:30 $
 * $Revision: 1.5 $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdarg.h> 

#ifdef __DJGPP__
#include "include/tcp_djgp.h"
#elif __TURBOC__
#include "include/tcp.h"
#endif

#include "include/ssh.h"
#include "include/des.h"
#include "include/blowfish.h"
#include "include/version.h"
#include "include/protocol.h"

extern int connectssh(void);

extern char privileged;

char debug=0;
char verbose=0;
FILE *fileptr=NULL;
int cipher=0;				/* cipher of or off*/
int cipher_type=SSH_CIPHER_3DES;	/* type of cipher */

unsigned char *inbuf=NULL;  /* buffer for incoming raw packet */

struct Packet pktin = { 0, 0, 0, NULL, 0 };
struct Packet pktout = { 0, 0, 0, NULL, 0 };

tcp_Socket s;		/* socket */
int status;		/* status of communication */
unsigned char username[20];
unsigned char password[20];
short passwdcmd=0;	/* password from command line? */
unsigned char *remotehost, *remotefile, *localfile;
int ssh_port=22;
char command[512];

/* fatal error handler */
void fatal(const char *fmt, ...)
{
va_list ap;
char buf[1024];

  va_start(ap, fmt);
  vsprintf(buf, fmt, ap);
  va_end(ap);
  fprintf(stderr, "%s\n", buf);
  if(fileptr!=NULL) fclose(fileptr);
  if(inbuf!=NULL) free(inbuf);
  sock_close(&s);
  exit(255);
}


void sendcommand(void)
{
int len;
	s_wrpkt_start(13, (len = strlen(command)) + 4);
	pktout.body[0] = pktout.body[1] = 0;
	pktout.body[2] = (len >> 8) & 0xFF;
	pktout.body[3] = len & 0xFF;		/* up to 32k of string */
	memcpy(pktout.body+4, command, len);
	s_wrpkt();
}

/* Client loop. This runs until SSH connection is terminated */
int getfile(void)
{
int len,i;

	sock_tick(&s, &status); /* TCP wait */
	len=sock_fastread(&s,inbuf,4); /* Read some data */
	if(!len) return(0); /* Begin loop again if none */
	for (i = len = 0; i < 4; i++) len = (len << 8) + inbuf[i]; /* Get packet size */
	sock_read(&s,inbuf+4,len + 8 - (len%8)); /* Read it */
	ssh_gotdata(inbuf); /* uncrypt and get valuable data */

	switch(pktin.type) {
		case SSH_SMSG_STDOUT_DATA:
			{
			if((len=fwrite(pktin.body+4, pktin.length-5, 1, fileptr))
				!=1) fatal ("\nWrite error");
			putch('#');
			break;
			}
		case SSH_SMSG_STDERR_DATA:
			{
			pktin.body[pktin.length-1]=0;
			cprintf("\n\r%s\r", pktin.body+4);
			fatal("Aborting...");
			}
		case SSH_SMSG_EXITSTATUS:
			{
			s_wrpkt_start(SSH_CMSG_EXIT_CONFIRMATION,0);
			s_wrpkt();
	                return(EXIT_SSH);
			}
		case SSH_MSG_DISCONNECT:
			{
			 /* Connection reset by other party */
			pktin.body[pktin.length+4]=0;
			cputs(pktin.body+4);
			return(EXIT_SSH);
			}
		case	SSH_SMSG_SUCCESS:
			{
			break;
			}
		default:
			{
			cprintf("Unsupported packet received. Type: %d\n\r",pktin.type);
			return(0);
			}
		}
return(0);

sock_err:
  switch (status)
  {
    case 1 : cputs ("Connection closed\n\r");
             break;
    case -1: cputs ("REMOTE HOST CLOSED CONNECTION\n\r");
             break;
  }
  return(EXIT_SSH);

}


/* Get command line arguments */

void getargs(int argc, char *argv[])
{
int i, j, len;
char *s;
char *usage="Usage: scpdos [options] username remotehost:remotefile localfile\n"
	    "Options:\n"
	    "-c <3des|blowfish>     - cipher type\n"
	    "-p <port number>       - remote port\n"
	    "-P                     - use non privileged local port\n"
	    "-s                     - remote password\n"
	    "-v                     - verbose output\n"
	    "Default is 3des cipher.";

    for (i = 1; i < argc; ++i)
    {
	s = argv[i];
	if (*s != '-') break;
	switch (*++s)
	{
	case '\0':
	    fatal(usage);
	    return;

	case 'c':
	    if (*++s)
		{
		 if(!strcmp(s,"3des")) cipher_type = SSH_CIPHER_3DES;
		 else if(!strcmp(s,"blowfish")) cipher_type = SSH_CIPHER_BLOWFISH;
		 else fatal(usage);
		}
	    else if (++i < argc)
		{
		if(!strcmp(argv[i],"3des")) cipher_type = SSH_CIPHER_3DES;
		else if(!strcmp(argv[i],"blowfish")) cipher_type = SSH_CIPHER_BLOWFISH;
		else fatal(usage);
		}
	    else
		fatal(usage);
	    continue;

	case 'p':
	    if (*++s)
		 ssh_port = atoi(s);
	    else if (++i < argc)
		ssh_port = atoi(argv[i]);
	    else
		fatal(usage);
	    continue;

	case 'P':
	    privileged=0;
	    continue;

	case 's':
	    passwdcmd=1;
	    if (*++s) strncpy(password,s,20);
	    else if (++i < argc) strncpy(password,argv[i],20);
	    else
		fatal(usage);
	    continue;

	case 'v':
	    verbose=1;
	    continue;

	default:
	    fatal(usage);
	} /* end switch */

    }

no_more_options:;
    if (i + 3 != argc) fatal(usage);
    strncpy(username,argv[i++],20);
    remotehost = argv[i++];
    remotefile = remotehost;
    localfile = argv[i++];

    len=strlen(remotehost);
    while(*remotefile != ':' && len>0)
	{
	remotefile++; len--;
	}
    if(len==0) fatal(usage);
    *remotefile=0;
    remotefile++;

    strcat(command, "cat ");
    strcat(command, remotefile);
}



/* main program */
int main(int argc, char **argv)
{
int i, ch;

    cprintf("SCPDOS v%s\n\r", SSH_VERSION);
    if((inbuf=malloc(INBUF_SIZE))==NULL) fatal("Not enough memory");

/* Do some preinitializations */

    memset(username,0,20);
    memset(password,0,20);

    getargs(argc, argv);

/* Initalizations */

    srand (time(NULL)); /* Initialize random number generator */

    if(connectssh()) fatal("Connection error"); /* Connect to remote server */


#ifdef __DJGPP__
    tcp_cbreak(1);	/* No Break checking under DJGPP */
#endif



   if((fileptr=fopen(localfile,"r"))==NULL)
	{
	if((fileptr=fopen(localfile,"wb"))==NULL)
		fatal("Cannot create localfile");
	}
   else
	{
	cprintf("Local file exists. Overwrite? (Y/N)\n\r");
	if((ch=getch())=='y')
		{
		if((fileptr=fopen(localfile,"wb"))==NULL)
			fatal("Cannot create localfile");
		}
	else fileptr=NULL;
	}


if(fileptr)
	{
	   cprintf("Receiving file: ");
	   sendcommand();
	   /* get the file */
	   while(EXIT_SSH!=getfile());
	   fclose(fileptr);
	}

free(inbuf);

/* Close TCP socket */

sock_close(&s);
return(0);

sock_err:
  switch (status)
  {
    case 1 : cputs ("Connection closed\n\r");
             break;
    case -1: cputs ("REMOTE HOST CLOSED CONNECTION\n\r");
             break;
  }
  if(fileptr!=NULL) fclose(fileptr);
  if(inbuf!=NULL) free(inbuf);
  return(1);
}

