/* Protocol data prototypes */

struct Packet {
    long length;
    int type;
    unsigned long crc;
    unsigned char *data;
    unsigned char *body;
    long maxlen;
};

/* get a packet with blocking */
int packet_read_block(void);

/* expect a packet type */
void packet_read_expect(int type);

/* create header for raw outgoing packet */
void s_wrpkt_start(int type, int len);

/* create outgoing packet */
void s_wrpkt(void);

/* convert raw, encrypted packet to readable structure */
void ssh_gotdata(unsigned char *data);
