//
// bmath.hxx
//
// Leonard Janke
// August 1996

#ifndef _BMATH_HXX
#define _BMATH_HXX

#include "lmisc.hxx"
#include <iostream.h>
#include <iomanip.h>

class BMath
{
public:
  static inline char GreaterThanOrEqualTo(const unsigned int*, 
	const unsigned int*, 
					  const int);

  static inline void BasicAdd(const unsigned int*, const unsigned int*, 
			      unsigned int*, const int, char&);

  static void Add(const unsigned int*, const unsigned int*, unsigned int*, 
		  const int, const int, char&);

  static inline void RippleAdd(const unsigned int*, const unsigned int*, 
			       unsigned int*, const int);

  static inline void BasicSubtract(const unsigned int*, const unsigned int*, 
				   unsigned int*, const int size, char&);

  static void Subtract(const unsigned int*, const unsigned int*, unsigned int*,
		       const int, const int);

  static inline void RippleSubtract(const unsigned int*, const unsigned int*, 
				    unsigned int*, const int);

  static inline void Increment(unsigned int* linteger, int size,
			       char& carry);

  static inline void RippleIncrement(unsigned int*, const int);

  static inline void RippleDecrement(unsigned int*, const int);

  static inline void BasicMultiply(const unsigned int*, unsigned int, 
				   unsigned int*, const int);

  static inline void MultDouble(unsigned int*, const unsigned int*, 
				const unsigned int*);

  static inline void SquareDouble(unsigned int*, const unsigned int*);

  static void Multiply(const unsigned int*, int, const unsigned int*, int, 
		       unsigned int*);
  
  static void Square(const unsigned int*, const int, unsigned int*);

  static inline void BasicDivide(unsigned int, unsigned int, unsigned int, 
				 unsigned int&, unsigned int&);

  static void Divide(const unsigned int*, int, const unsigned int*, int,
		     unsigned int*&, unsigned int*&);

  static inline int BSR(unsigned int);

  static inline char Normalize(unsigned int*, int);

  static inline void ShiftLeft(unsigned int*, int , char);

  static inline void ShiftRight(unsigned int*, int, char);
};

#include "bmath.asm"

#endif
