/* skipjack.c */

#include "../../lib/libdefs.h"
#include "../../lib/mcrypt_modules.h"
#include "skipjack.h"

#define _mcrypt_set_key skipjack_LTX__mcrypt_set_key
#define _mcrypt_encrypt skipjack_LTX__mcrypt_encrypt
#define _mcrypt_decrypt skipjack_LTX__mcrypt_decrypt
#define _mcrypt_get_size skipjack_LTX__mcrypt_get_size
#define _mcrypt_get_block_size skipjack_LTX__mcrypt_get_block_size
#define _is_block_algorithm skipjack_LTX__is_block_algorithm
#define _mcrypt_get_key_size skipjack_LTX__mcrypt_get_key_size
#define _mcrypt_get_supported_key_sizes skipjack_LTX__mcrypt_get_supported_key_sizes
#define _mcrypt_get_algorithms_name skipjack_LTX__mcrypt_get_algorithms_name
#define _mcrypt_self_test skipjack_LTX__mcrypt_self_test
#define _mcrypt_algorithm_version skipjack_LTX__mcrypt_algorithm_version


#define BLOCKSIZE 8
#define KEYSIZE 10

static const unsigned char F[] = {
	0xA3, 0xD7, 0x09, 0x83, 0xF8, 0x48, 0xF6, 0xF4,
	0xB3, 0x21, 0x15, 0x78, 0x99, 0xB1, 0xAF, 0xF9,
	0xE7, 0x2D, 0x4D, 0x8A, 0xCE, 0x4C, 0xCA, 0x2E,
	0x52, 0x95, 0xD9, 0x1E, 0x4E, 0x38, 0x44, 0x28,
	0x0A, 0xDF, 0x02, 0xA0, 0x17, 0xF1, 0x60, 0x68,
	0x12, 0xB7, 0x7A, 0xC3, 0xE9, 0xFA, 0x3D, 0x53,
	0x96, 0x84, 0x6B, 0xBA, 0xF2, 0x63, 0x9A, 0x19,
	0x7C, 0xAE, 0xE5, 0xF5, 0xF7, 0x16, 0x6A, 0xA2,
	0x39, 0xB6, 0x7B, 0x0F, 0xC1, 0x93, 0x81, 0x1B,
	0xEE, 0xB4, 0x1A, 0xEA, 0xD0, 0x91, 0x2F, 0xB8,
	0x55, 0xB9, 0xDA, 0x85, 0x3F, 0x41, 0xBF, 0xE0,
	0x5A, 0x58, 0x80, 0x5F, 0x66, 0x0B, 0xD8, 0x90,
	0x35, 0xD5, 0xC0, 0xA7, 0x33, 0x06, 0x65, 0x69,
	0x45, 0x00, 0x94, 0x56, 0x6D, 0x98, 0x9B, 0x76,
	0x97, 0xFC, 0xB2, 0xC2, 0xB0, 0xFE, 0xDB, 0x20,
	0xE1, 0xEB, 0xD6, 0xE4, 0xDD, 0x47, 0x4A, 0x1D,
	0x42, 0xED, 0x9E, 0x6E, 0x49, 0x3C, 0xCD, 0x43,
	0x27, 0xD2, 0x07, 0xD4, 0xDE, 0xC7, 0x67, 0x18,
	0x89, 0xCB, 0x30, 0x1F, 0x8D, 0xC6, 0x8F, 0xAA,
	0xC8, 0x74, 0xDC, 0xC9, 0x5D, 0x5C, 0x31, 0xA4,
	0x70, 0x88, 0x61, 0x2C, 0x9F, 0x0D, 0x2B, 0x87,
	0x50, 0x82, 0x54, 0x64, 0x26, 0x7D, 0x03, 0x40,
	0x34, 0x4B, 0x1C, 0x73, 0xD1, 0xC4, 0xFD, 0x3B,
	0xCC, 0xFB, 0x7F, 0xAB, 0xE6, 0x3E, 0x5B, 0xA5,
	0xAD, 0x04, 0x23, 0x9C, 0x14, 0x51, 0x22, 0xF0,
	0x29, 0x79, 0x71, 0x7E, 0xFF, 0x8C, 0x0E, 0xE2,
	0x0C, 0xEF, 0xBC, 0x72, 0x75, 0x6F, 0x37, 0xA1,
	0xEC, 0xD3, 0x8E, 0x62, 0x8B, 0x86, 0x10, 0xE8,
	0x08, 0x77, 0x11, 0xBE, 0x92, 0x4F, 0x24, 0xC5,
	0x32, 0x36, 0x9D, 0xCF, 0xF3, 0xA6, 0xBB, 0xAC,
	0x5E, 0x6C, 0xA9, 0x13, 0x57, 0x25, 0xB5, 0xE3,
	0xBD, 0xA8, 0x3A, 0x01, 0x05, 0x59, 0x2A, 0x46
};

void g(unsigned char *key, int *i, unsigned char *high, unsigned char *low)
{
	(*high) ^= F[(*low) ^ key[*i]];
	(*i)++;
	(*i) %= KEYSIZE;
	(*low) ^= F[(*high) ^ key[*i]];
	(*i)++;
	(*i) %= KEYSIZE;
	(*high) ^= F[(*low) ^ key[*i]];
	(*i)++;
	(*i) %= KEYSIZE;
	(*low) ^= F[(*high) ^ key[*i]];
	(*i)++;
	(*i) %= KEYSIZE;
}

void g_inverse(unsigned char *key, int *i,
	       unsigned char *high, unsigned char *low)
{
	(*low) ^= F[(*high) ^ key[(*i)]];
	(*i)--;
	if ((*i) < 0) {
		(*i) = KEYSIZE - 1;
	}
	(*high) ^= F[(*low) ^ key[(*i)]];
	(*i)--;
	if ((*i) < 0) {
		(*i) = KEYSIZE - 1;
	}
	(*low) ^= F[(*high) ^ key[(*i)]];
	(*i)--;
	if ((*i) < 0) {
		(*i) = KEYSIZE - 1;
	}
	(*high) ^= F[(*low) ^ key[(*i)]];
	(*i)--;
	if ((*i) < 0) {
		(*i) = KEYSIZE - 1;
	}
}

void _mcrypt_set_key(char *inst, char *key, int len)
{
	Bzero(inst, KEYSIZE);
	memmove(inst, key, len);
}


void _mcrypt_encrypt(unsigned char *key, unsigned char *block)
{
	int i = 0;
	unsigned char c = 0;
	unsigned char temp[2];

	while (c < 32) {
		while (c % 16 != 8) {
			c++;
			// Temp := Ciphertext(6 .. 7);
			memcpy(&(temp[0]), &(block[6]), 2);
			// Ciphertext(2 .. 7) := Ciphertext(0 .. 5);
			memmove(&(block[2]), &(block[0]), BLOCKSIZE - 2);
			// G(Key, I, Ciphertext(2), Ciphertext(3));
			g(key, &i, &(block[2]), &(block[3]));
			// Ciphertext(0) := Temp(0) xor Ciphertext(2);
			block[0] = temp[0] ^ block[2];
			// Ciphertext(1) := Temp(1) xor Ciphertext(3) xor Counter;
			block[1] = temp[1] ^ block[3] ^ c;
		}
		while (c % 16 != 0) {
			c++;
			// Temp := Ciphertext(6 .. 7);
			memcpy(&(temp[0]), &(block[6]), 2);
			// Ciphertext(2 .. 7) := Ciphertext(0 .. 5);
			memmove(&(block[2]), &(block[0]), BLOCKSIZE - 2);
			// Ciphertext(4) := Ciphertext(4) xor Ciphertext(0);
			block[4] ^= block[0];
			// Ciphertext(5) := Ciphertext(5) xor Ciphertext(1) xor Counter;
			block[5] = block[5] ^ block[1] ^ c;
			// G(Key, I, Ciphertext(2), Ciphertext(3));
			g(key, &i, &(block[2]), &(block[3]));
			// Ciphertext(0 .. 1) := Temp;
			memcpy(&(block[0]), &(temp[0]), 2);
		}
	}
}

void _mcrypt_decrypt(unsigned char *key, unsigned char *block)
{
	int i = (4 * 4 * 8 - 1) % KEYSIZE;
	unsigned char c = 4 * 8;
	unsigned char temp[2];

	while (c > 0) {
		while (c % 16 != 8) {
			// Temp := Plaintext(0 .. 1);
			memcpy(&(temp[0]), &(block[0]), 2);
			// Plaintext(0 .. 5) := Plaintext(2 .. 7);
			memmove(&(block[0]), &(block[2]), BLOCKSIZE - 2);
			// G_Inverse(Key, I, Plaintext(0), Plaintext(1));
			g_inverse(key, &i, &(block[0]), &(block[1]));
			// Plaintext(2) := Plaintext(2) xor Plaintext(0);
			block[2] = block[2] ^ block[0];
			// Plaintext(3) := Plaintext(3) xor Plaintext(1) xor Counter;
			block[3] = block[3] ^ block[1] ^ c;
			// Plaintext(6 .. 7) := Temp;
			memcpy(&(block[6]), &(temp[0]), 2);
			c--;
		}
		while (c % 16 != 0) {
			// Temp(0) := Plaintext(0) xor Plaintext(2);
			temp[0] = block[0] ^ block[2];
			// Temp(1) := Plaintext(1) xor Plaintext(3) xor Counter;
			temp[1] = block[1] ^ block[3] ^ c;
			// Plaintext(0 .. 5) := Plaintext(2 .. 7);
			memmove(&(block[0]), &(block[2]), BLOCKSIZE - 2);
			// G_Inverse(Key, I, Plaintext(0), Plaintext(1));
			g_inverse(key, &i, &(block[0]), &(block[1]));
			// Plaintext(6 .. 7) := Temp;
			memcpy(&(block[6]), &(temp[0]), 2);
			c--;
		}
	}
}

int _mcrypt_self_test(void)
{
	unsigned char k[KEYSIZE] = { 0x00, 0x99, 0x88, 0x77, 0x66,
		0x55, 0x44, 0x33, 0x22, 0x11
	};
	unsigned char bcler[BLOCKSIZE] = { 0x33, 0x22, 0x11, 0x00,
		0xDD, 0xCC, 0xBB, 0xAA
	};
	unsigned char bciph[BLOCKSIZE] = { 0x25, 0x87, 0xCA, 0xE2,
		0x7A, 0x12, 0xD3, 0x00
	};
	unsigned char bwork[BLOCKSIZE];

	memcpy(bwork, bcler, BLOCKSIZE);
	_mcrypt_encrypt(k, bwork);
	if (memcmp(bciph, bwork, BLOCKSIZE) != 0)
		return 1;
	_mcrypt_decrypt(k, bwork);
	if (memcmp(bcler, bwork, BLOCKSIZE) != 0)
		return 1;

	return 0;
}

int _mcrypt_get_size()
{
	return sizeof(KEYSIZE);
}

int _mcrypt_get_block_size()
{
	return 8;
}

int _is_block_algorithm()
{
	return 1;
}

int _mcrypt_get_key_size()
{
	return KEYSIZE;
}
int *_mcrypt_get_supported_key_sizes(int *len)
{
	int *size = malloc(1 * sizeof(int));
	size[0] = 10;
	*len = 1;
	return size;
}

char *_mcrypt_get_algorithms_name()
{
	char *x;
	x = malloc(10);
	strcpy(x, "Skipjack");
	return x;
}

word32 _mcrypt_algorithm_version()
{
	return 20000229;
}
