#define end_mcrypt_ecb end_mcrypt

/* Defines for backwards compatibility */
#define get_block_size mcrypt_get_block_size
#define get_key_size mcrypt_get_key_size
#define get_algorithms_name mcrypt_get_algorithms_name

/* generic - high level functions. These are a bit slower because
 * they perform a switch before each call but they have the advantage
 * of being able to check at run-time which modes are in the library
 * and use them
 */

int mcrypt_generic_init(const int mode,
                    const int algorithm, void *key, int lenofkey, void *IV);
int mcrypt_generic_end(const int td);
int mdecrypt_generic(int td, void *plaintext, int len);
int mcrypt_generic(int td, void *plaintext, int len);
                    

/* extra functions */

int mcrypt_get_block_size(int algorithm);
int mcrypt_get_key_size(int algorithm);

int is_ok_algorithm(int algorithm); /* if this algorithm exists returns 0 */
int is_ok_mode(int mode); /* if this mode exists returns 0 */

char* mcrypt_get_algorithms_name(int algorithm);
char *get_modes_name(int mode);

int init_mcrypt ( const int mode, const int algorithm, int thread, void * key, int lenofkey);
int mcrypt(int thread, void *plaintext);
int mdecrypt(int thread, void *plaintext);
int end_mcrypt(int td);

/* ECB */
int init_mcrypt_ecb( const int algorithm, void * key, int lenofkey);
int mcrypt_ecb(int thread, void *plaintext,int len);
int mdecrypt_ecb(int thread, void *plaintext, int);

/* CBC */
int end_mcrypt_cbc(int td);
int mcrypt_cbc(int td, void *plaintext, int);
int mdecrypt_cbc(int td, void *ciphertext, int);
int init_mcrypt_cbc( const int algorithm, void * key, int lenofkey);

/* CFB */
int end_mcrypt_cfb(int td);
int mcrypt_cfb(int td, void *plaintext,int len);
int mdecrypt_cfb(int td, void *ciphertext, int len);
int init_mcrypt_cfb( const int algorithm, void * key, int lenofkey, void *IV);

/* OFB */
int end_mcrypt_ofb(int td);
int mcrypt_ofb(int td, void *plaintext,int len);
int mdecrypt_ofb(int td, void *ciphertext, int len);
int init_mcrypt_ofb( const int algorithm, void * key, int lenofkey, void *IV);

/* nbit OFB */
int init_mcrypt_nofb(const int algorithm, void *key, int lenofkey, void *IV);
int mcrypt_nofb(int td, void *plaintext, int len);
int mdecrypt_nofb(int td, void *plaintext, int len);
int end_mcrypt_nofb(int td);


void gen_key(void *keyword, void *salt, int salt_size, int key_size,
             unsigned char *password, int plen);

# define BLOWFISH 0
# define DES 1 
# define TripleDES 2
# define ThreeWAY 3
# define GOST 4
# define SAFER64 6
# define SAFER128 7
# define CAST128 8
# define TEAN 9
# define RC2 11
# define TWOFISH128 10
# define TWOFISH192 12
# define TWOFISH256 13

#ifdef NON_FREE
# define RC6 100
# define IDEA 101
#endif

#define CBC 0
#define ECB 1
#define CFB 2
#define OFB 3
#define nOFB 4
