/* Copyright (C) 1998,1999 Nikos Mavroyanopoulos This library is free
 * software; you can redistribute it and/or modify it under the terms of the
 * GNU Library General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef LIBDEFS_H
#define LIBDEFS_H
#include <libdefs.h>
#endif
#include <bzero.h>
#include <swap.h>
#include <mcrypt.h>
#include <blowfish.h>
#include <3-way.h>
#include <gost.h>
#include <des.h>
#include <safer.h>
#include <cast.h>
#include <tean.h>
#include <aes.h>
#include <xmemory.h>
#include <rc2.h>
#include <rc6.h>
#include <idea.h>
#include <sha1.h>

int mcrypt_get_block_size(int algorithm)
{
	switch (algorithm) {

	case DES:
	case TripleDES:
	case BLOWFISH:
	case GOST:
	case SAFER64:
	case SAFER128:
	case CAST128:
	case TEAN:
	case RC2:
		return 8;
		break;

#ifdef NON_FREE
	case IDEA:
		return 8;
		break;

	case RC6:
		return 16;
		break;
#endif

	case TWOFISH128:
	case TWOFISH192:
	case TWOFISH256:
		return 16;
		break;

	case ThreeWAY:
		return 12;
		break;

	default:
		return 0;
	}


}

int mcrypt_get_key_size(int algorithm)
{				/* In bytes */
	switch (algorithm) {

	case DES:
	case SAFER64:
		return 8;	/* Actually 7 but the algorithm here uses 8 */
		break;

	case TripleDES:
		return 24;
		break;

	case BLOWFISH:
		return 56;
		break;

	case RC2:
		return 128;
		break;

#ifdef NON_FREE
	case RC6:
		return RC6_BKEY;	/* 32 */
		break;
#endif

	case TWOFISH192:
		return 24;
		break;

	case GOST:
	case TWOFISH256:
		return 32;
		break;

	case TWOFISH128:
		return 16;
		break;

	case ThreeWAY:
		return 12;
		break;

	case SAFER128:
	case CAST128:
	case TEAN:
#ifdef NON_FREE
	case IDEA:
#endif
		return 16;
		break;

	default:
		return 0;
	}

}



char *get_algorithms_name(int algorithm)
{

	char *x = mxmalloc(20);

	switch (algorithm) {
	case DES:
		strcpy(x, "DES");
		return x;
		break;

	case RC2:
		strcpy(x, "RC2");
		return x;
		break;

#ifdef NON_FREE
	case IDEA:
		strcpy(x, "IDEA");
		return x;
		break;

	case RC6:
		strcpy(x, "RC6");
		return x;
		break;
#endif

	case TripleDES:
		strcpy(x, "3DES");
		return x;
		break;

	case ThreeWAY:
		strcpy(x, "3-WAY");
		return x;
		break;

	case BLOWFISH:
		strcpy(x, "Blowfish");
		return x;
		break;

	case TWOFISH128:
		strcpy(x, "Twofish-128");
		return x;
		break;
	case TWOFISH192:
		strcpy(x, "Twofish-192");
		return x;
		break;
	case TWOFISH256:
		strcpy(x, "Twofish-256");
		return x;
		break;

	case GOST:
		strcpy(x, "GOST");
		return x;
		break;

	case SAFER64:
		strcpy(x, "SAFER-SK64");
		return x;
		break;

	case SAFER128:
		strcpy(x, "SAFER-SK128");
		return x;
		break;
	case CAST128:
		strcpy(x, "CAST-128");
		return x;
		break;
	case TEAN:
		strcpy(x, "xTEA");
		return x;
		break;
	}
	return NULL;

}


int is_ok_algorithm(int algorithm)
{

	switch (algorithm) {
	case DES:
	case RC2:
#ifdef NON_FREE
	case IDEA:
	case RC6:
#endif
	case TripleDES:
	case ThreeWAY:
	case BLOWFISH:
	case TWOFISH128:
	case TWOFISH192:
	case TWOFISH256:
	case GOST:
	case SAFER64:
	case SAFER128:
	case CAST128:
	case TEAN:
		return 0;
		break;

	default:
		return 1;
		break;

	}

}

int is_ok_mode(int mode)
{				/* if this mode exists returns 0 */

	switch (mode) {
	case OFB:
	case CFB:
	case CBC:
	case ECB:
	case nOFB:
		return 0;
		break;

	default:
		return 1;
		break;

	}
}


void gen_key(void *keyword, void *salt, int salt_size, int key_size,
	     unsigned char *password, int plen)
{
	unsigned char key[MAX_KEY_LEN];
	SHA1_CTX ctx;
	unsigned char *digest;
	int size = key_size;
	unsigned char *cp = key, *cp0 = key;
	int salt_z = 0;		/* flag to be used when freeing salt[] */

	if (salt == NULL) {
		salt_z = 1;
	}
	while (1) {
		SHA1Init(&ctx);
		if (salt_z == 0)
			SHA1Update(&ctx, salt, salt_size);
		SHA1Update(&ctx, password, plen);
		if (cp - cp0 > 0)
			SHA1Update(&ctx, cp0, cp - cp0);
		digest = SHA1Final(&ctx);
		if (size > 20) {
			memmove(cp, digest, 20);
			free(digest);
			size -= 20;
			cp += 20;
		} else {
			memmove(cp, digest, size);
			free(digest);
			break;
		}
	}
	memmove(keyword, key, key_size);
}


char *get_modes_name(int mode)
{

	char *x = mxmalloc(6);

	switch (mode) {
	case ECB:
		strcpy(x, "ECB");
		return x;
		break;

	case CBC:
		strcpy(x, "CBC");
		return x;
		break;

	case OFB:
		strcpy(x, "OFB");
		return x;
		break;

	case CFB:
		strcpy(x, "CFB");
		return x;
		break;

	case nOFB:
		strcpy(x, "nOFB");
		return x;
		break;
	default:
	        return NULL;

        }
}


