/* RC6 (RC6 16/20/32) Encrypt/Decrypt

    RC6 was written as a submission for AES by:

        Ronald L. Rivest, M.J.B Robshaw, R. Sidney, and Y.L Yin

    Written for Micro-C (portable) by Tom St Denis.


    The ammount of rounds and bytes per key are changeable at compile time,
but are defaulted to 20/32.  So it uses 20 rounds to encrypt 64-bits per
block using a 32 byte key (256 bits). 

Notes:

    1.  Currently if you call encrypt/decrypt seperately, it uses ECB.
    You may want to use another method such as CFB, CBC or PCBC, all of
    which can be used on top of encrypt/decrypt.

    2.  The key you pass to schedule must be at least BKEY bytes long, and
    have NULL padding if it's not that size.

    3.  The ammount of ROUNDS effects the effective strength of cipher.
    Anything between 10 and 40 is ok.  40 is a conservative high-end, and
    20 is the default.  You can also change the key length.  Keys anywhere
    from 128bits (16 bytes) to 512bits (64 bytes) are ok, but they must
    be a multiple of 2 bytes.  Also you can change the word size.  I think
    16/32 are the only really valid options, however you can use 64 too.

    4.  The memory required per scheduled key is:
            size = 4r + 8
        where r is the number of rounds.  Default is 88 bytes.

    5.  If you plan to use this with other compilers change all unsigned
    variables to unsigned short (make them 16 bits).

    6.  RC6 is a block cipher.  The default is 64-bit blocks.

    7.  Read Ronald's paper on RC6 for more detailed information.

    Micro-C is copyrighted Dave Dunfield.
    Tom St Denis, 1999
*/

#define RC6_ROUNDS      20              /* rounds per packet */
#define BITS            32              /* bits per word */

#define P           0xB7E1          /* upper BITS of 0xB7E151628AED2A6B */
#define Q           0x9E37          /* upper BITS of 0x9E3779B97F4A7C15 */

#define RC6_FACTOR      ((RC6_ROUNDS * 2) + 4)
#define RC6_BKEY        32              /* bytes per key */

void rc6_encrypt(word32 packet[4], word32 skey[]);
void rc6_decrypt(word32 packet[4], word32 skey[]);
void rc6_schedule(unsigned char key[], word32 skey[]);
