#include "../lib/mcrypt.h"
#include <stdio.h>
#include <strings.h>
#include <stdlib.h>

char test0[2][500];

int main() {

int i;
int j,x=0;
unsigned char *keyword, *password;
unsigned char cipher_tmp[500];


printf("Checking whether the key generation work normally\n");

/* Test vectors with key and plaintext == zero */
strcpy( test0[0],  "e7fa316f2807182bfb60f4422e6fd8a8981e43b1704602e790c5dc88c24a19ea0ebd03f30309a7b4b0a2d33ca13b176918ac5d8d57fd0eca0204f40231dcbcb8d96923d09a5af16f6739a65a84bec1cf79f0fa363a8cae3a3c3fc05dbb08072ba147c5b8a77ac238de2ca9138ba188061af930658f2ea1c70aebe330d5976bfd");
strcpy( test0[1],  "1c782c46c11a8c82541b7814e196b2ab5f5f3afc744ce85de51dcea1ee0e76b64b1dc3d07aad34f220aec6b475d2ba7346bbbc14f5bf97b39b54f856bda3a0c4b949f277946f3f16c899696c834a4ca41467678075f40f6bc159938063934456efe754d8b217c7bd6c1be946f91c661cef693b078694bf731658f03d6cdf8f5e");
bzero( cipher_tmp, sizeof(cipher_tmp));

   i=RC2; /* Not really needed */
   
   password = malloc( mcrypt_get_key_size(i));
   keyword = malloc( mcrypt_get_key_size(i));

   memset( password, '\2', mcrypt_get_key_size(i));
   memset( password, '\3', mcrypt_get_key_size(i)/2);
   memset( password, '\5', mcrypt_get_key_size(i)/4);
   gen_key_sha1( keyword, NULL, 0, mcrypt_get_key_size(i), password, mcrypt_get_key_size(i));

   printf("SHA-1: ");   
#ifdef DEBUG
   printf ("\npassword:    ");
   for (j=0; j< mcrypt_get_key_size(i); j++)
        printf("%.2x", password[j]);
   printf("\n");
#endif


   for (j=0; j<mcrypt_get_key_size(i); j++) {
     sprintf( &((char*)cipher_tmp)[2*j], "%.2x", keyword[j]);
   }

#ifdef DEBUG
   printf("HASH: ");
   printf("%s\n", cipher_tmp);   
#endif

   if (strcmp( (void*) cipher_tmp, (void*) test0[0])!=0) {
        printf ("failed compatibility\n");
        x=1;
   } else {
        printf("ok\n");
   }

   gen_key_md5( keyword, NULL, 0, mcrypt_get_key_size(i), password, mcrypt_get_key_size(i));

   printf("MD5: ");   
#ifdef DEBUG
   printf ("\npassword:    ");
   for (j=0; j< mcrypt_get_key_size(i); j++) {
     printf("%.2x", password[j]);
   }   
   printf ("\n");
#endif


   for (j=0; j<mcrypt_get_key_size(i); j++) {
     sprintf( &((char*)cipher_tmp)[2*j], "%.2x", keyword[j]);
   }

#ifdef DEBUG
   printf("HASH: ");
   printf("%s\n", cipher_tmp);   
#endif

   if (strcmp( (void*) cipher_tmp, (void*) test0[1])!=0) {
        printf ("failed compatibility\n");
        x=1;
   } else {
        printf("ok\n");
   }


   free(keyword);
   free(password);

return x;

}

