/* First example using TWOFISH-128 and CFB */

#include <mcrypt.h>
#include <stdio.h>
#include <stdlib.h>

main() {

  int td, i;
  char *key; /* possibly created using gen_key */
  char block_buffer[16];
  char *IV;

  key=calloc(1, mcrypt_get_key_size(TWOFISH128));
  strcpy(key, "A_large_key");
  IV=malloc(mcrypt_get_block_size(TWOFISH128));

/* Put random data in IV. Note these are not real random data, 
 * consider using /dev/random or /dev/urandom.
 */
    srand(time(0));
  for (i=0; i<mcrypt_get_block_size(TWOFISH128); i++) {
    IV[i]=rand();
  }

  td=mcrypt_generic_init(CFB, TWOFISH128, key, strlen(key), IV);

  /* Encryption in CFB is performed in bytes */
  while ( fread (block_buffer, 1, 1, stdin) == 1 ) {
      mcrypt_generic (td, block_buffer, 1);
//      mdecrypt_generic (td, block_buffer, 1);
      fwrite ( block_buffer, 1, 1, stdout);
  }
  mcrypt_generic_end(td);

  return 0;

}




/* Second Example using CBC and TWOFISH-192 */

#include <mcrypt.h>
#include <stdio.h>
#include <stdlib.h>

main() {

  int td, i;
  char *key; /* created using gen_key */
  char block_buffer[16]; /* This is the block_size of the algorithm
                          * of course it can be malloc'ed using mcrypt_get_block_size()
                          */
  char *IV;

  key=calloc(1, mcrypt_get_key_size(TWOFISH192));
  strcpy(key, "A_large_and_random_key");
  IV=malloc(mcrypt_get_block_size(TWOFISH192));

/* Put random data in IV. Note these are not real random data, 
 * consider using /dev/random or /dev/urandom.
 */
    srand(time(0));
  for (i=0; i<mcrypt_get_block_size(TWOFISH192); i++) {
    IV[i]=rand();
  }

  td=mcrypt_generic_init (CBC, TWOFISH192, key, strlen(key), IV);

  /* Encryption in CFB is performed in bytes */
  while ( fread (block_buffer, 1, mcrypt_get_block_size(TWOFISH192), stdin) == mcrypt_get_block_size(TWOFISH192) ) {
      mcrypt_generic (td, block_buffer, mcrypt_get_block_size(TWOFISH192));
//      mdecrypt_generic (td, block_buffer, mcrypt_get_block_size(TWOFISH192));
      fwrite ( block_buffer, 1, mcrypt_get_block_size(TWOFISH192), stdout);
  }
  mcrypt_generic_end (td);

  return 0;

}
