
/* Copyright (C) 1998,1999 Nikos Mavroyanopoulos
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef LIBDEFS_H
# define LIBDEFS_H
# include <libdefs.h>
#endif
#include <bzero.h>

#ifdef HAVE_SYS_MMAN_H
# include <sys/mman.h>
#endif

#ifdef HAVE_MLOCK
void LOCKMEM(void *x, size_t size)
{
	mlock(x, size);
}

# define UNLOCKMEM(x,y) munlock(x,y)
#else
# define LOCKMEM(x,y)
# define UNLOCKMEM(x,y)
#endif

#include <bzero.h>
#include <xmemory.h>

/* memory allocation */

void *mxmalloc(size_t size)
{
	char *x;

	x = malloc(size);

	if (x != NULL) {
		LOCKMEM(x, size);
		return x;
	} else {
		sleep(1);
		x = malloc(size);
		if (x != NULL) {
			LOCKMEM(x, size);
			return x;
		} else {
			fprintf(stderr, ("Cannot allocate memory\n"));
			exit(-1);
		}
	}
/* Not really needed */
	return x;
}

void *mxcalloc(size_t nmemb, size_t size)
{
	char *x;

	x = calloc(nmemb, size);
	if (x != NULL) {
		return x;
		LOCKMEM(x, size);
	} else {
		sleep(1);
		x = calloc(nmemb, size);
		if (x != NULL) {
			LOCKMEM(x, size);
			return x;
		} else {
			fprintf(stderr, ("Cannot allocate memory\n"));
			exit(-1);
		}
	}
/* Not really needed */
	return x;

}

void *mxrealloc(void *ptr, size_t size)
{
	char *x;

	x = realloc(ptr, size);
	if (x != NULL) {
		LOCKMEM(x, size);
		return x;
	} else {
		sleep(1);
		x = realloc(ptr, size);
		if (x != NULL) {
			LOCKMEM(x, size);
			return x;
		} else {
			fprintf(stderr, ("Cannot allocate memory\n"));
			exit(-1);
		}
	}
/* Not really needed */
/* Just for some compilers which complain */
	return x;

}


void mxfree(void *ptr, size_t size)
{

	Bzero(ptr, size);
	UNLOCKMEM(ptr, size);
	free(ptr);

}
