
word16 byteswap_16(word16 x);

#define FAST

#ifdef FAST
	#define rotl(x,n)   (((x) << ((word32)(n))) | ((x) >> (32 - (word32)(n))))
	#define rotr(x,n)   (((x) >> ((word32)(n))) | ((x) << (32 - (word32)(n))))
	#define rotl16(x,n)   (((x) << ((word16)(n))) | ((x) >> (16 - (word16)(n))))
	#define rotr16(x,n)   (((x) >> ((word16)(n))) | ((x) << (16 - (word16)(n))))
	#define byteswap(x)	((rotl(x, 8) & 0x00ff00ff) | (rotr(x, 8) & 0xff00ff00))
#else
	word16 rotl16(word16 v, word16 cnt);
	word16 rotr16(word16 v, word16 cnt);
	word32 rotl(word32 v, word32 cnt);
	word32 rotr(word32 v, word32 cnt);
	word32 byteswap(word32 x);
#endif
