/* Copyright (C) 1998,1999 Nikos Mavroyanopoulos
 * This library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "../../lib/libdefs.h"
#include "../../lib/mcrypt_modules.h"
#include "wake.h"

#define _mcrypt_set_key wake_LTX__mcrypt_set_key
#define _mcrypt_encrypt wake_LTX__mcrypt_encrypt
#define _mcrypt_decrypt wake_LTX__mcrypt_decrypt
#define _mcrypt_get_size wake_LTX__mcrypt_get_size
#define _mcrypt_get_block_size wake_LTX__mcrypt_get_block_size
#define _is_block_algorithm wake_LTX__is_block_algorithm
#define _mcrypt_get_key_size wake_LTX__mcrypt_get_key_size
#define _mcrypt_get_algo_iv_size wake_LTX__mcrypt_get_algo_iv_size
#define _mcrypt_get_supported_key_sizes wake_LTX__mcrypt_get_supported_key_sizes
#define _mcrypt_get_algorithms_name wake_LTX__mcrypt_get_algorithms_name
#define _mcrypt_self_test wake_LTX__mcrypt_self_test
#define _mcrypt_algorithm_version wake_LTX__mcrypt_algorithm_version

/* WAKE reference C-code, based on the description in David J. Wheeler's
 * paper "A bulk Data Encryption Algorithm"
 */
 
/* The IV option is a libmcrypt extension. In order to be compatible with
 * other implementations initialize it as NULL and it's size as 0.
 */

static word32 tt[10] = {
	0x726a8f3b,
	0xe69a3b5c,
	0xd3c71fe5,
	0xab3c73d2,
	0x4d3a8eb3,
	0x0396d6e8,
	0x3d4c2f7a,
	0x9ee27cf3
};

void _mcrypt_set_key(WAKE_KEY *wake_key, word32* key, int ignlen, char* IV, int ivlen)
{
/* ign len is ignored since the key must be exactly 256 bits */
	word32 x, z, p;

#ifdef WORDS_BIGENDIAN
	wake_key->k[0]=byteswap(key[0]);
	wake_key->k[1]=byteswap(key[1]);
	wake_key->k[2]=byteswap(key[2]);
	wake_key->k[3]=byteswap(key[3]);
#else
	wake_key->k[0]=key[0];
	wake_key->k[1]=key[1];
	wake_key->k[2]=key[2];
	wake_key->k[3]=key[3];
#endif

if (ivlen>0) {	
	for (p = 0; p < 4; p++) {
			wake_key->t[p] = wake_key->k[p] + IV[p%ivlen];
	}
} else {
	for (p = 0; p < 4; p++) {
			wake_key->t[p] = wake_key->k[p];
	}
}

if (ivlen>0) {		
	for (p = 4; p < 256; p++) {
		x = wake_key->t[p - 4] + wake_key->t[p - 1] + IV[p%ivlen];
		wake_key->t[p] = x >> 3 ^ tt[x & 7];
	}
} else {
	for (p = 4; p < 256; p++) {
		x = wake_key->t[p - 4] + wake_key->t[p - 1];
		wake_key->t[p] = x >> 3 ^ tt[x & 7];
	}
}

	for (p = 0; p < 23; p++)
		wake_key->t[p] += wake_key->t[p + 89];

	x = wake_key->t[33];
	z = wake_key->t[59] | 0x01000001;
	z = z & 0xff7fffff;

	for (p = 0; p < 256; p++) {
		x &= 0xff7fffff;
		x += z;
		wake_key->t[p] = (wake_key->t[p] & 0x00ffffff) ^ x;
	}

	wake_key->t[256] = wake_key->t[0];
	x &= 255;

	for (p = 0; p < 256; p++) {
		wake_key->t[p] = wake_key->t[x = (wake_key->t[p ^ x] ^ x) & 255];
		wake_key->t[x] = wake_key->t[p + 1];
	}
	
	wake_key->counter=0;
	wake_key->r[0] = wake_key->k[0];
	wake_key->r[1] = wake_key->k[1];
	wake_key->r[2] = wake_key->k[2];
#ifdef WORDS_BIGENDIAN
	wake_key->r[3] = byteswap(wake_key->k[3]);
#else
	wake_key->r[3] = wake_key->k[3];
#endif

}
 
#define r2 wake_key->input_buffer
#define r1 wake_key->input_buffer
#define counter wake_key->counter

void _mcrypt_encrypt( WAKE_KEY *wake_key, word8 * input, int len)
{
	word32 r3, r4, r5, r6;
	int i;
	
	r3 = wake_key->r[0];
	r4 = wake_key->r[1];
	r5 = wake_key->r[2];
	r6 = wake_key->r[3];
	
	
	for (i=0;i<len;i++) {
 		input[i] ^= ((word8*)&r6)[counter];
		((word8*)&r2)[counter]=input[i];
                counter++;
                
                if (counter==sizeof(word32)) {
                	counter=0;
#ifdef WORDS_BIGENDIAN
			r2 = byteswap(r2);
			r6 = byteswap(r6);
#endif
			r3 += r2;
			r3 = (r3 >> 8) ^ wake_key->t[r3 & 255];
			r4 += r3;
			r4 = (r4 >> 8) ^ wake_key->t[r4 & 255];
			r5 += r4;
			r5 = (r5 >> 8) ^ wake_key->t[r5 & 255];
			r6 += r5;
			r6 = (r6 >> 8) ^ wake_key->t[r6 & 255];
#ifdef WORDS_BIGENDIAN
			r6 = byteswap(r6);
#endif
		}
	}
	
	wake_key->r[0] = r3;
	wake_key->r[1] = r4;
	wake_key->r[2] = r5;
	wake_key->r[3] = r6;

}


void _mcrypt_decrypt(WAKE_KEY *wake_key, word8 * input, int len)
{
	word32 r3, r4, r5, r6;
	int i;
	
	r3 = wake_key->r[0];
	r4 = wake_key->r[1];
	r5 = wake_key->r[2];
	r6 = wake_key->r[3];
	
	
	for (i=0;i<len;i++) {
		((word8*)&r1)[counter]=input[i];
 		input[i] ^= ((word8*)&r6)[counter];
                counter++;
                
                if (counter==sizeof(word32)) {
                	counter=0;
#ifdef WORDS_BIGENDIAN
			r1 = byteswap(r1);
			r6 = byteswap(r6);
#endif
			r3 += r1;
			r3 = (r3 >> 8) ^ wake_key->t[r3 & 255];
			r4 += r3;
			r4 = (r4 >> 8) ^ wake_key->t[r4 & 255];
			r5 += r4;
			r5 = (r5 >> 8) ^ wake_key->t[r5 & 255];
			r6 += r5;
			r6 = (r6 >> 8) ^ wake_key->t[r6 & 255];
#ifdef WORDS_BIGENDIAN
			r6 = byteswap(r6);
#endif
		}
	}
	
	wake_key->r[0] = r3;
	wake_key->r[1] = r4;
	wake_key->r[2] = r5;
	wake_key->r[3] = r6;

}


int _mcrypt_get_size () {return sizeof(WAKE_KEY);}
int _mcrypt_get_block_size() { return 1; }
int _mcrypt_get_algo_iv_size() { return 32; }
int _is_block_algorithm() { return 0; }
int _mcrypt_get_key_size() { return 32; }
int* _mcrypt_get_supported_key_sizes(int *len) {
	int *size=malloc(1*sizeof(int));
	size[0]=32;
	*len=1;
        return size;
}
char * _mcrypt_get_algorithms_name() { char*x; x=malloc(5); strcpy(x, "WAKE"); return x;}

#define CIPHER "2225242b659c4e974ba1d2eb95554f627149f289"

int _mcrypt_self_test() {
	char *keyword;
	unsigned char *plaintext;
        unsigned char *ciphertext;
        int blocksize=20, j;
        void *key;
        unsigned char cipher_tmp[200];
                         
	keyword = calloc(1, _mcrypt_get_key_size());
        for (j=0; j< _mcrypt_get_key_size(); j++) {
               keyword[j]=(j*2+10)%256;
        }
                                
	ciphertext = malloc(blocksize);
        plaintext = malloc(blocksize);
        for (j=0; j< blocksize; j++) {
	        plaintext[j]=j%256;
	}
	key=malloc(_mcrypt_get_size());
	memcpy(ciphertext, plaintext, blocksize);

	_mcrypt_set_key( key, (void*)keyword, _mcrypt_get_key_size(), NULL, 0);
	_mcrypt_encrypt( key, (void*)ciphertext, blocksize);

        for (j = 0; j < blocksize; j++) {
               sprintf(&((char *) cipher_tmp)[2 * j], "%.2x",
               ciphertext[j]);
        }

	if (strcmp( (char*)cipher_tmp, CIPHER) != 0) {
	        printf("failed compatibility\n");
	        printf("Expected: %s\nGot: %s\n", CIPHER, (char*)cipher_tmp);
	        return -1;
	}
	_mcrypt_set_key( key, (void*)keyword, _mcrypt_get_key_size(), NULL, 0);
	_mcrypt_decrypt( key, (void*)ciphertext,  blocksize);

	if (strcmp( ciphertext, plaintext) != 0) {
	        printf("failed internally\n");
	        return -1;
	}
	return 0;
}

word32 _mcrypt_algorithm_version() {
	return 19991129;
}
