/**********************************************************
   TEA - Tiny Encryption Algorithm
   Feistel cipher by David Wheeler & Roger M. Needham
   (extended version)
 **********************************************************/

/* $Id: xtea.c,v 1.5 2000/02/02 20:15:50 nikos Exp $ */

#include "../../lib/libdefs.h"
#include "../../lib/mcrypt_modules.h"

#define _mcrypt_set_key xtea_LTX__mcrypt_set_key
#define _mcrypt_encrypt xtea_LTX__mcrypt_encrypt
#define _mcrypt_decrypt xtea_LTX__mcrypt_decrypt
#define _mcrypt_get_size xtea_LTX__mcrypt_get_size
#define _mcrypt_get_block_size xtea_LTX__mcrypt_get_block_size
#define _is_block_algorithm xtea_LTX__is_block_algorithm
#define _mcrypt_get_key_size xtea_LTX__mcrypt_get_key_size
#define _mcrypt_get_supported_key_sizes xtea_LTX__mcrypt_get_supported_key_sizes
#define _mcrypt_get_algorithms_name xtea_LTX__mcrypt_get_algorithms_name
#define _mcrypt_self_test xtea_LTX__mcrypt_self_test
#define _mcrypt_algorithm_version xtea_LTX__mcrypt_algorithm_version

#define ROUNDS 32
#define DELTA 0x9e3779b9	/* sqr(5)-1 * 2^31 */

/**********************************************************
   Input values: 	k[4]	128-bit key
			v[2]    64-bit plaintext block
   Output values:	v[2]    64-bit ciphertext block 
 **********************************************************/


void _mcrypt_set_key (word32 *k, word32* input_key, int len) {
	k[0]=0;		k[2]=0;
	k[1]=0;		k[3]=0;
	memmove (k, input_key,len);
}

void _mcrypt_encrypt(word32 * k, word32 * v)
{
#ifdef WORDS_BIGENDIAN
	word32 y = v[0], z = v[1];
#else
	word32 y = byteswap(v[0]), z = byteswap(v[1]);
#endif
	word32 limit, sum = 0;
	int N=ROUNDS;

	if (N > 0) {		/* ENCRYPT */
		limit = DELTA * N;
#ifdef WORDS_BIGENDIAN
		while (sum != limit) {
			y += ((z << 4 ^ z >> 5) + z) ^ (sum + k[sum & 3]);
			sum += DELTA;
			z +=
			    ((y << 4 ^ y >> 5) + y) ^ (sum +
						       k[(sum >> 11) & 3]);
		}
	} else {		/* DECRYPT */
		sum = DELTA * (-N);
		while (sum) {
			z -=
			    ((y << 4 ^ y >> 5) + y) ^ (sum +
						       k[(sum >> 11) & 3]);
			sum -= DELTA;
			y -= ((z << 4 ^ z >> 5) + z) ^ (sum + k[sum & 3]);
#else
		while (sum != limit) {
			y +=
			    ((z << 4 ^ z >> 5) + z) ^ (sum +
						       byteswap(k
								[sum &
								 3]));
			sum += DELTA;
			z +=
			    ((y << 4 ^ y >> 5) + y) ^ (sum +
						       byteswap(k
								[
								 (sum >>
								  11) &
								 3]));
		}
	} else {		/* DECRYPT */
		sum = DELTA * (-N);
		while (sum) {
			z -=
			    ((y << 4 ^ y >> 5) + y) ^ (sum +
						       byteswap(k
								[
								 (sum >>
								  11) &
								 3]));
			sum -= DELTA;
			y -=
			    ((z << 4 ^ z >> 5) + z) ^ (sum +
						       byteswap(k
								[sum &
								 3]));
#endif
		}
	}
#ifdef WORDS_BIGENDIAN
	v[0] = y;
	v[1] = z;
#else
	v[0] = byteswap(y);
	v[1] = byteswap(z);
#endif
}

void _mcrypt_decrypt(word32 * k, word32 * v)
{
#ifdef WORDS_BIGENDIAN
	word32 y = v[0], z = v[1];
#else
	word32 y = byteswap(v[0]), z = byteswap(v[1]);
#endif
	word32 limit, sum = 0;
	int N=-ROUNDS;

	if (N > 0) {		/* ENCRYPT */
		limit = DELTA * N;
#ifdef WORDS_BIGENDIAN
		while (sum != limit) {
			y += ((z << 4 ^ z >> 5) + z) ^ (sum + k[sum & 3]);
			sum += DELTA;
			z +=
			    ((y << 4 ^ y >> 5) + y) ^ (sum +
						       k[(sum >> 11) & 3]);
		}
	} else {		/* DECRYPT */
		sum = DELTA * (-N);
		while (sum) {
			z -=
			    ((y << 4 ^ y >> 5) + y) ^ (sum +
						       k[(sum >> 11) & 3]);
			sum -= DELTA;
			y -= ((z << 4 ^ z >> 5) + z) ^ (sum + k[sum & 3]);
#else
		while (sum != limit) {
			y +=
			    ((z << 4 ^ z >> 5) + z) ^ (sum +
						       byteswap(k
								[sum &
								 3]));
			sum += DELTA;
			z +=
			    ((y << 4 ^ y >> 5) + y) ^ (sum +
						       byteswap(k
								[
								 (sum >>
								  11) &
								 3]));
		}
	} else {		/* DECRYPT */
		sum = DELTA * (-N);
		while (sum) {
			z -=
			    ((y << 4 ^ y >> 5) + y) ^ (sum +
						       byteswap(k
								[
								 (sum >>
								  11) &
								 3]));
			sum -= DELTA;
			y -=
			    ((z << 4 ^ z >> 5) + z) ^ (sum +
						       byteswap(k
								[sum &
								 3]));
#endif
		}
	}
#ifdef WORDS_BIGENDIAN
	v[0] = y;
	v[1] = z;
#else
	v[0] = byteswap(y);
	v[1] = byteswap(z);
#endif
}

/*
void _mcrypt_encrypt(word32 * k, word32 * v)
{
	_mcrypt_tean(k, v, ROUNDS);
}

void _mcrypt_decrypt(word32 * k, word32 * v)
{
	_mcrypt_tean(k, v, -ROUNDS);
}
*/

int _mcrypt_get_size () {return 4*sizeof(word32);}
int _mcrypt_get_block_size() { return 8; }
int _is_block_algorithm() { return 1; }
int _mcrypt_get_key_size() { return 16; }
int* _mcrypt_get_supported_key_sizes(int *len) {
        int *size=malloc(1*sizeof(int));
        size[0]=16;
	*len=1;
        return size;
}
char * _mcrypt_get_algorithms_name() { char*x; x=malloc(10); strcpy(x, "xTEA"); return x;}

#define CIPHER "f61e7ff6da7cdb27"

int _mcrypt_self_test() {
	char *keyword;
	unsigned char *plaintext;
        unsigned char *ciphertext;
        int blocksize=_mcrypt_get_block_size(), j;
        void *key;
        unsigned char cipher_tmp[200];
                         
	keyword = calloc(1, _mcrypt_get_key_size());
        for (j=0; j< _mcrypt_get_key_size(); j++) {
	        keyword[j]=((j*2+10)%256);
	}
	ciphertext = malloc(blocksize);
        plaintext = malloc(blocksize);
        for (j=0; j< blocksize; j++) {
	        plaintext[j]=j%256;
	}
	key=malloc(_mcrypt_get_size());
	memcpy(ciphertext, plaintext, blocksize);

	_mcrypt_set_key( key, (void*)keyword, _mcrypt_get_key_size());
	_mcrypt_encrypt( key, (void*)ciphertext);

        for (j = 0; j < blocksize; j++) {
               sprintf(&((char *) cipher_tmp)[2 * j], "%.2x",
               ciphertext[j]);
        }

	if (strcmp( (char*)cipher_tmp, CIPHER) != 0) {
	        printf("failed compatibility\n");
	        printf("Expected: %s\nGot: %s\n", CIPHER, (char*)cipher_tmp);
	        return -1;
	}
	_mcrypt_decrypt( key, (void*)ciphertext);

	if (strcmp( ciphertext, plaintext) != 0) {
	        printf("failed internally\n");
	        return -1;
	}
	return 0;
}

word32 _mcrypt_algorithm_version() {
	return 19991129;
}
