#include "../../lib/libdefs.h"
#include "../../lib/mcrypt_modules.h"

#define _init_mcrypt nofb_LTX__init_mcrypt
#define _end_mcrypt nofb_LTX__end_mcrypt
#define _mcrypt nofb_LTX__mcrypt
#define _mdecrypt nofb_LTX__mdecrypt
#define _has_iv nofb_LTX__has_iv
#define _is_block_mode nofb_LTX__is_block_mode
#define _is_block_algorithm_mode nofb_LTX__is_block_algorithm_mode
#define _mcrypt_get_modes_name nofb_LTX__mcrypt_get_modes_name
#define _mcrypt_mode_get_size nofb_LTX__mcrypt_mode_get_size
#define _mcrypt_mode_version nofb_LTX__mcrypt_mode_version

typedef struct nofb_buf {
	word8* sd_register;
	word8* s_register;
	word8* enc_s_register;
	word8* enc_sd_register;
} nOFB_BUFFER;

/* nOFB MODE */

int _init_mcrypt( nOFB_BUFFER* buf, void *key, int lenofkey, void *IV, int size)
{
/* For ofb */
	buf->sd_register=malloc( size);
	buf->s_register=malloc( size);
	buf->enc_s_register=malloc( size);
	buf->enc_sd_register=malloc( size);
	memmove(buf->sd_register, IV, size);
	memmove(buf->s_register, IV, size);

/* End ofb */

	return 0;

}


void _end_mcrypt( nOFB_BUFFER* buf) {
	free(buf->sd_register);
	free(buf->s_register);
	free(buf->enc_sd_register);
	free(buf->enc_s_register);
}


int _mcrypt( nOFB_BUFFER* buf,void *plaintext, int len, int blocksize, void* akey, void (*func)(void*,void*), void (*func2)(void*,void*))
{				/* plaintext is n*blocksize bytes (nbit ofb) */
	word32 *plain, *fplain = plaintext;
	int i, j;
	void (*_mcrypt_block_encrypt) (void *, void *);

	_mcrypt_block_encrypt = func;


	for (j = 0; j < len / blocksize; j++) {
		plain = &fplain[j * blocksize / sizeof(word32)];
		memmove(buf->enc_s_register, buf->s_register, blocksize);
		_mcrypt_block_encrypt(akey, buf->enc_s_register);

		for (i = 0; i < blocksize / sizeof(word32); i++) {
			plain[i] ^=
			    ((word32 *) &
			     buf->enc_s_register[0 +
						i * sizeof(word32)])[0];
		}
/* Put the new register */
		memmove(buf->s_register, buf->enc_s_register, blocksize);
	}
	return 0;
}


int _mdecrypt( nOFB_BUFFER* buf, void *plaintext, int len, int blocksize, void* akey, void (*func)(void*,void*), void (*func2)(void*,void*))
{				/* plaintext is n bytes (nbit ofb) */
	word32 *plain, *fplain = plaintext;
	int i, j;
	void (*_mcrypt_block_encrypt) (void *, void *);

	_mcrypt_block_encrypt = func;


	for (j = 0; j < len / blocksize; j++) {
		plain = &fplain[j * blocksize / sizeof(word32)];
		memmove(buf->enc_sd_register, buf->sd_register, blocksize);
		_mcrypt_block_encrypt(akey, buf->enc_sd_register);

/* Shift the register */
		memmove(buf->sd_register, buf->enc_sd_register, blocksize);

		for (i = 0; i < blocksize / sizeof(word32); i++) {
			plain[i] ^=
			    ((word32 *) &
			     buf->enc_sd_register[0 +  i * sizeof(word32)])[0];
		}
	}

	return 0;
}

int _has_iv() { return 1; }
int _is_block_mode() { return 1; }
int _is_block_algorithm_mode() { return 1; }
char *_mcrypt_get_modes_name() { char*x; x=malloc(10); strcpy(x, "nOFB"); return x;}
int _mcrypt_mode_get_size () {return sizeof(nOFB_BUFFER);}


word32 _mcrypt_mode_version() {
	return 20000331;
}
