/* 
 * Copyright (C) 1998,1999,2000 Nikos Mavroyanopoulos
 *
 * This library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "../../lib/libdefs.h"
#include "../../lib/mcrypt_modules.h"
#include <stdlib.h>
#include "arcfour.h"

#ifdef USE_LTDL
#define _mcrypt_set_key arcfour_LTX__mcrypt_set_key
#define _mcrypt_encrypt arcfour_LTX__mcrypt_encrypt
#define _mcrypt_decrypt arcfour_LTX__mcrypt_decrypt
#define _mcrypt_get_size arcfour_LTX__mcrypt_get_size
#define _mcrypt_get_block_size arcfour_LTX__mcrypt_get_block_size
#define _is_block_algorithm arcfour_LTX__is_block_algorithm
#define _mcrypt_get_key_size arcfour_LTX__mcrypt_get_key_size
#define _mcrypt_get_algo_iv_size arcfour_LTX__mcrypt_get_algo_iv_size
#define _mcrypt_get_supported_key_sizes arcfour_LTX__mcrypt_get_supported_key_sizes
#define _mcrypt_get_algorithms_name arcfour_LTX__mcrypt_get_algorithms_name
#define _mcrypt_self_test arcfour_LTX__mcrypt_self_test
#define _mcrypt_algorithm_version arcfour_LTX__mcrypt_algorithm_version
#endif


/* key is the state that should be allocated by the caller */
WIN32DLL_DEFINE
void _mcrypt_set_key(arcfour_key *key, word8 *key_data, int key_len, char* IV, int iv_len)
{
  word8 tmp, j;
  word8* state;
  short i;

  state = key->state;
  
  for(i = 0; i < 256; i++)
	  state[i] = i;
	  
  key->i = 0;
  key->j = 0;
 
  j=0;
  
  for(i=0; i<256; i++) {
 	j = (j+state[i]+key_data[i % key_len]);
	tmp = state[i];
	state[i] = state[j];
	state[j] = tmp;
  }

  tmp = j = i = 0;
 
}

#define I key->i
#define J key->j
#define STATE key->state
WIN32DLL_DEFINE
void _mcrypt_encrypt(arcfour_key *key, word8 *buffer_ptr, int buffer_len)
{
  word8 tmp;
  int counter;
  
  for(counter = 0; counter < buffer_len; counter++)
  {
    I++;
    J += STATE[I];
    
    /* swap STATE[I] and STATE[J] */
    tmp = STATE[I];
    STATE[I]=STATE[J];
    STATE[J]=tmp;
    
    tmp = STATE[I]+STATE[J];
    buffer_ptr[counter] ^= STATE[tmp];
  }
}

/* this is the same with mcrypt_encrypt */
WIN32DLL_DEFINE
void _mcrypt_decrypt(arcfour_key *key, word8 *buffer_ptr, int buffer_len)
{
  word8 tmp;
  int counter;
  
  for(counter = 0; counter < buffer_len; counter++)
  {
    I++;
    J += STATE[I];
    
    /* swap STATE[I] and STATE[J] */
    tmp = STATE[I];
    STATE[I]=STATE[J];
    STATE[J]=tmp;
    
    tmp = STATE[I]+STATE[J];
    buffer_ptr[counter] ^= STATE[tmp];
  }
}

WIN32DLL_DEFINE
int _mcrypt_get_size () {return sizeof(arcfour_key);}
WIN32DLL_DEFINE
int _mcrypt_get_block_size() { return 1; }
WIN32DLL_DEFINE
int _mcrypt_get_algo_iv_size() { return 0; }
WIN32DLL_DEFINE
int _is_block_algorithm() { return 0; }
WIN32DLL_DEFINE
int _mcrypt_get_key_size() { return 256; }
WIN32DLL_DEFINE
int* _mcrypt_get_supported_key_sizes(int *len) {
	*len=0;
	return NULL;
}
WIN32DLL_DEFINE
char * _mcrypt_get_algorithms_name() { char*x; x=malloc(5); strcpy(x, "RC4"); return x;}

#define CIPHER "3abaa03a286e24c4196d292ab72934d6854c3eee"

WIN32DLL_DEFINE
int _mcrypt_self_test() {
	char *keyword;
	unsigned char *plaintext;
        unsigned char *ciphertext;
        int blocksize=20, j;
        void *key;
        unsigned char cipher_tmp[200];
                         
	keyword = calloc(1, _mcrypt_get_key_size());
        for (j=0; j< _mcrypt_get_key_size(); j++) {
	        keyword[j]=((j*2+10)%256);
	}
	ciphertext = malloc(blocksize);
        plaintext = malloc(blocksize);
        for (j=0; j< blocksize; j++) {
	        plaintext[j]=j%256;
	}
	key=malloc(_mcrypt_get_size());
	memcpy(ciphertext, plaintext, blocksize);

	_mcrypt_set_key( key, (void*)keyword, _mcrypt_get_key_size(), NULL, 0);
	_mcrypt_encrypt( key, (void*)ciphertext, blocksize);

        for (j = 0; j < blocksize; j++) {
               sprintf(&((char *) cipher_tmp)[2 * j], "%.2x",
               ciphertext[j]);
        }

	if (strcmp( (char*)cipher_tmp, CIPHER) != 0) {
	        printf("failed compatibility\n");
	        printf("Expected: %s\nGot: %s\n", CIPHER, (char*)cipher_tmp);
	        return -1;
	}

	_mcrypt_set_key( key, (void*)keyword, _mcrypt_get_key_size(), NULL, 0);
	_mcrypt_decrypt( key, (void*)ciphertext,  blocksize);

	if (strcmp( ciphertext, plaintext) != 0) {
	        printf("failed internally\n");
	        return -1;
	}
	return 0;
}

WIN32DLL_DEFINE
word32 _mcrypt_algorithm_version() {
        return 20001001;
}

