/* ANSI-C code produced by gperf version 2.7.2 */
/* Command-line: gperf -LANSI-C -t -c -l -k1,3,5 -N find_macro  */
#include "macros.h"
struct macro_def { char *name; int id; int len; };

#define TOTAL_KEYWORDS 51
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 13
#define MIN_HASH_VALUE 2
#define MAX_HASH_VALUE 140
/* maximum key range = 139, duplicates = 0 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
hash (register const char *str, register unsigned int len)
{
  static unsigned char asso_values[] =
    {
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141,  55, 141,  22,  60,   0,
        0,  35,  10,  15, 141, 141,   0,  11,  25,   5,
       25, 141,  50,   0,   0,  10,  15,   0, 141,  25,
      141, 141, 141, 141, 141,   0, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
      141, 141, 141, 141, 141, 141
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 5:
        hval += asso_values[(unsigned char)str[4]];
      case 4:
      case 3:
        hval += asso_values[(unsigned char)str[2]];
      case 2:
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval;
}

#ifdef __GNUC__
#endif
struct macro_def *
find_macro (register const char *str, register unsigned int len)
{
  static unsigned char lengthtable[] =
    {
       0,  0,  2,  0,  4,  0,  0,  0,  0,  9, 10,  0,  0,  8,
       4, 10,  0,  0,  8,  9,  5,  0,  0, 13,  4,  3,  6,  5,
       0,  9,  8,  0,  0,  8,  0, 10,  0,  0,  3,  3,  8,  5,
       0,  7,  0,  0,  0,  0,  0,  3,  0,  5,  0,  0,  4,  0,
       0,  0,  0,  9, 10,  0,  0,  0,  4, 10,  6,  7,  8,  0,
       0,  0,  0,  7,  0,  0,  6,  5,  0,  9,  0,  0,  7,  0,
       4, 10,  6,  7,  3,  0,  5,  5,  0,  7,  0,  0,  0,  0,
       8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  6,  0,  0,  0,
       5
    };
  static struct macro_def wordlist[] =
    {
      {""}, {""},
      {"TZ", M_TZ},
      {""},
      {"S_TZ", M_TZ_STAMP},
      {""}, {""}, {""}, {""},
      {"S_WEEKDAY", M_WEEKDAY_STAMP},
      {"S_FULLDATE", M_FULLDATE_STAMP},
      {""}, {""},
      {"TZOFFSET", M_TZOFFSET},
      {"HOST", M_HOST},
      {"S_TZOFFSET", M_TZOFFSET_STAMP},
      {""}, {""},
      {"FULLHOST", M_FULLHOST},
      {"HOST_FROM", M_HOST_FROM},
      {"LEVEL", M_LEVEL},
      {""}, {""},
      {"FULLHOST_FROM", M_FULLHOST_FROM},
      {"HOUR", M_HOUR},
      {"SEC", M_SEC},
      {"S_HOUR", M_HOUR_STAMP},
      {"S_SEC", M_SEC_STAMP},
      {""},
      {"S_ISODATE", M_ISODATE_STAMP},
      {"FACILITY", M_FACILITY},
      {""}, {""},
      {"UNIXTIME", M_UNIXTIME},
      {""},
      {"S_UNIXTIME", M_UNIXTIME_STAMP},
      {""}, {""},
      {"TAG", M_TAG},
      {"MIN", M_MIN},
      {"SOURCEIP", M_SOURCE_IP},
      {"S_MIN", M_MIN_STAMP},
      {""},
      {"S_MONTH", M_MONTH_STAMP},
      {""}, {""}, {""}, {""}, {""},
      {"MSG", M_MESSAGE},
      {""},
      {"MONTH", M_MONTH},
      {""}, {""},
      {"R_TZ", M_TZ_RECVD},
      {""}, {""}, {""}, {""},
      {"R_WEEKDAY", M_WEEKDAY_RECVD},
      {"R_FULLDATE", M_FULLDATE_RECVD},
      {""}, {""}, {""},
      {"DATE", M_DATE},
      {"R_TZOFFSET", M_TZOFFSET_RECVD},
      {"S_DATE", M_DATE_STAMP},
      {"WEEKDAY", M_WEEKDAY},
      {"FULLDATE", M_FULLDATE},
      {""}, {""}, {""}, {""},
      {"MESSAGE", M_MESSAGE},
      {""}, {""},
      {"R_HOUR", M_HOUR_RECVD},
      {"R_SEC", M_SEC_RECVD},
      {""},
      {"R_ISODATE", M_ISODATE_RECVD},
      {""}, {""},
      {"ISODATE", M_ISODATE},
      {""},
      {"YEAR", M_YEAR},
      {"R_UNIXTIME", M_UNIXTIME_RECVD},
      {"S_YEAR", M_YEAR_STAMP},
      {"PROGRAM", M_PROGRAM},
      {"DAY", M_DAY},
      {""},
      {"S_DAY", M_DAY_STAMP},
      {"R_MIN", M_MIN_RECVD},
      {""},
      {"R_MONTH", M_MONTH_RECVD},
      {""}, {""}, {""}, {""},
      {"PRIORITY", M_LEVEL},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"R_DATE", M_DATE_RECVD},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"R_YEAR", M_YEAR_RECVD},
      {""}, {""}, {""},
      {"R_DAY", M_DAY_RECVD}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        if (len == lengthtable[key])
          {
            register const char *s = wordlist[key].name;

            if (*str == *s && !memcmp (str + 1, s + 1, len - 1))
              return &wordlist[key];
          }
    }
  return 0;
}
