/* This utility is intended to convert a machine readable workload
   file into a human-readable version. it is used as part of a sanity
   check when parsing logfiles. */

#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "netlib3.h"
#include "nettest3_ftp.h"

char usage_string[] = "\
machine_to_human -i input [-h] [-w human_output] \n\
                 [-v verbosity] \n";

typedef struct command {
  int    next_offset;
  int    command_code;
  int    retcode;
  char   parm[BUFSIZ];
} command_t;




char *
code_to_str(int command_code)
{
  switch (command_code) {
  case CLOS:
    return "CLOS";

  case CWD:
    return "CWD";
      
  case LIST:
    return "LIST";

  case MDTM:
    return "MDTM";

  case NLST:
    return "NLST";

  case NOOP:
    return "NOOP";

  case OPEN:
    return "OPEN";

  case PASS:
    return "PASS";

  case PASV:
    return "PASV";

  case PORT:
    return "PORT";

  case PWD:
    return "PWD";

  case QUIT:
    return "QUIT";

  case REST:
    return "REST";

  case RETR:
    return "RETR";

  case SIZE:
    return "SIZE";

  case STAT:
    return "STAT";

  case SYST:
    return "SYST";

  case TYPE:
    return "TYPE";

  case USER:
    return "USER";

  case WAIT:
    return "WAIT";

  default:
    return "UNKN";
  }
}



void
print_command(command_t *command, FILE *human)
{

  command_t *temp = command;

  if (temp->parm[0]) {
    fprintf(human,
	    "%d %s %d %s\n",
	    temp->next_offset,
	    code_to_str(temp->command_code),
	    temp->retcode,
	    temp->parm);
  }
  else {
    fprintf(human,
	    "%d %s %d\n",
	    temp->next_offset,
	    code_to_str(temp->command_code),
	    temp->retcode);
  }

}



int
main(int argc, char *argv[])

{
  int input;
  FILE *human = stdout;
  struct stat statbuf;

  command_t *command;

  void *mmap_base_addr;

  int verbosity = 1;

  char c;

  while ((c = getopt(argc,argv,"hi:v:w:")) != -1) {
  switch (c) {

  case 'i':

    if (stat(optarg,&statbuf) == -1) {
      perror("could not stat input file");
      exit(-1);
    }
    input = open(optarg,O_RDONLY);
    if (input == -1) {
      perror("could not open input file for reading");
      exit(-1);
    }

    mmap_base_addr = mmap(NULL,
			  statbuf.st_size,
			  PROT_READ,
			  MAP_SHARED,
			  input,
			  0);

    if (mmap_base_addr == (void *)-1) {
      perror("unable to mmap input file");
      exit(-1);
    }
    break;

  case 'v':
    verbosity = atoi(optarg);
    break;

  case 'w':
    human = fopen(optarg,"w");
    if (human == NULL) {
      perror("could not open human-readable output file for writing");
      exit(-2);
    }
    break;

  case 'h':
  case '?':
  case ':':
    fprintf(stderr,usage_string);
    exit(-1);
  }
  }

  command = (command_t *)mmap_base_addr;
  do {
    print_command(command,human);
    command = (command_t *)((char *)command + 
			    command->next_offset);
  } while (command < (command_t *)((char *)mmap_base_addr + 
				   statbuf.st_size)) ;

  fflush(human);

  return 0;
}
