/*
 
	      Copyright (C) 1998 Hewlett-Packard Company
                         ALL RIGHTS RESERVED.
 
  The enclosed software and documention includes copyrighted works of
  Hewlett-Packard Co. For as long as you comply with the following
  limitations, you are hereby authorized to (i) use, reproduce, and
  modify the software and documentation, and to (ii) distribute the
  software and documentation, including modifications, for
  non-commercial purposes only.
      
  1.  The enclosed software and documentation is made available at no
      charge in order to advance the general development of
      high-performance networking products.
 
  2.  You may not delete any copyright notices contained in the
      software or documentation. All hard copies, and copies in
      source code or object code form, of the software or
      documentation (including modifications) must contain at least
      one of the copyright notices.
 
  3.  The enclosed software and documentation has not been subjected
      to testing and quality control and is not a Hewlett-Packard Co.
      product. At a future time, Hewlett-Packard Co. may or may not
      offer a version of the software and documentation as a product.
  
  4.  THE SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS".
      HEWLETT-PACKARD COMPANY DOES NOT WARRANT THAT THE USE,
      REPRODUCTION, MODIFICATION OR DISTRIBUTION OF THE SOFTWARE OR
      DOCUMENTATION WILL NOT INFRINGE A THIRD PARTY'S INTELLECTUAL
      PROPERTY RIGHTS. HP DOES NOT WARRANT THAT THE SOFTWARE OR
      DOCUMENTATION IS ERROR FREE. HP DISCLAIMS ALL WARRANTIES,
      EXPRESS AND IMPLIED, WITH REGARD TO THE SOFTWARE AND THE
      DOCUMENTATION. HP SPECIFICALLY DISCLAIMS ALL WARRANTIES OF
      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
  
  5.  HEWLETT-PACKARD COMPANY WILL NOT IN ANY EVENT BE LIABLE FOR ANY
      DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
      (INCLUDING LOST PROFITS) RELATED TO ANY USE, REPRODUCTION,
      MODIFICATION, OR DISTRIBUTION OF THE SOFTWARE OR DOCUMENTATION.
 
*/

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef USE_THREADS
#include <pthread.h>
#endif
#include <assert.h>

#include "netlib3.h"
#define NETPERF
#include "netperf3.h"

/* seems that compilation on a stock HP-UX 11.00 system does not get
   these definitions - probably something I need to submit a bug for,
   or perhaps something I am not getting in my compile line? */

extern char *strtok_r(char *, const char *, char **);
extern char *strdup(const char *);

/* some forward declarations */
void scan_cmd_line(test_t *test);


const char netperf_usage[] = "\n\
Usage: netperf [global options] -- [test options] \n\
\n\
Global options:\n\
    -a send,recv      Set the local send,recv buffer alignment\n\
    -A send,recv      Set the remote send,recv buffer alignment\n\
    -c [cpu_rate]     Report local CPU usage\n\
    -C [cpu_rate]     Report remote CPU usage\n\
    -d                Increase debugging output\n\
    -f G|M|K|g|m|k    Set the output units\n\
    -F fill_file      Pre-fill buffers with data from fill_file\n\
    -h                Display this text\n\
    -H name|ip        Specify the target machines\n\
    -i max,min        Specify the max and min number of iterations (15,1)\n\
    -I lvl[,intvl]    Specify confidence level (95 or 99) (99) \n\
                      and confidence interval in percentage (10)\n\
    -l testlen        Specify test duration (>0 secs) (<0 bytes|trans)\n\
    -o send,recv      Set the local send,recv buffer offsets\n\
    -O send,recv      Set the remote send,recv buffer offset\n\
    -n numcpu         Set the number of processors for CPU util\n\
    -p port           Specify netserver port number\n\
    -P 0|1            Don't/Do display test headers\n\
    -t testname       Specify test to perform\n\
    -v verbosity      Specify the verbosity level\n\
    -W send,recv      Set the number of send,recv buffers\n\
\n\
For those options taking two parms, at least one must be specified;\n\
specifying one value without a comma will set both parms to that\n\
value, specifying a value with a leading comma will set just the second\n\
parm, a value with a trailing comma will set just the first. To set\n\
each parm to unique values, specify both and separate them with a\n\
comma.\n"; 

void
print_netperf_usage()
{
  fprintf(stderr,netperf_usage);
}


char *
break_hostnum(char *meta, int *num)

{
  char *meta_track = NULL;
  char *numchar;
  char *host;

  host = strtok_r(meta,"#",&meta_track);
  if (*host == NULL) {
    printf("whoa nelly\n");
    exit(-1);
  }
  numchar = strtok_r(NULL,"#",&meta_track);
  if (numchar == NULL) {
    *num = 1;
  }
  else {
    *num = atoi(numchar);
  }
  return(host);
}


uint32_t
make_hostlist(int argc, char *argv[], int *nargc, char *hostlist[])
{

  int i;
  int have_hosts = 0;
  int host_index;    /* argv[host_index] == "-H" */
  
  char c;
  char *hosts;
  char *host;

  char *hostnum;
  char *hostnum_trak;
  int  numhosts;
  int  j;


  if (debug) {
    fprintf(where,
	    "make_hostlist called with %d args and hostlist %x\n",
	    argc,
	    hostlist);
    fflush(where);
  }

  /* if we find no -H option, we want nargc to be argc */
  *nargc = argc;

  /* search for a -H option, but only in the globals, at this point,
     ignore everything but a -H with an argument. real syntax checking
     will be done later by the threads - true, it would be "faster" to
     find errors here, but this is not a place where speed is
     particularly important */
  while((c = getopt(argc,argv,GLOBAL_CMD_LINE_ARGS)) != EOF) {
    switch (c) {
    case '?':
      break;
    case 'H':
      /* we have a -H, and it has an argument. save-off the pointer to
       the hosts list and pull-up any remaining options. I *think*
       this may upset getopt, so we may have to break out of the while
       loop as well - and we will probably need to reset come of the
       getopt statics. raj 1/98 */
      have_hosts = 1;
      *nargc = argc -2;
      hosts = optarg;
      /* first, pull-back any remaining options, this will include the
	 null at the end of the list */
      for (i = optind; i < argc; i++) {
	argv[i-2] = argv[i];
      }
      /* we should probably null-out the remianing two slots to avoid
	 a double free when the program terminates */
      argv[i-2] = NULL;
      argv[i-1] = NULL;
      break;
    default:
      break;
    }
    /* once we find the hosts, we no longer want to search the list -
       I will not worry about someone using -H more than once at this
       point */
    if (have_hosts) {
      /* we will be calling getopt later with a different argv, so we
	 might as well reset optind now */
      optind = 1;
      break;
    }
  }
  /* now we want to break the host-string up into a list of names,
     with each host in the list as many times as specified by the
     #directive */

  j = 0;
  if (have_hosts) {
    hostnum = strtok_r(hosts,",",&hostnum_trak);
    while (hostnum != NULL) {
      host = break_hostnum(hostnum,&numhosts);
      for (i = 0;((i < numhosts) && (j < 64)); i++) {
	hostlist[j++] = strdup(host);
      }
      hostnum = strtok_r(NULL,",",&hostnum_trak);
    }
  }	
  else {
    /* there was no -H option given by the user, so we can assume this
       is a sigle-instance test to localhost */
    hostlist[j] = strdup("localhost");
    j = 1;
  }
  return(j);
}

void
copy_args(int argc, char *argv[], test_t *test, char *hostname)
{
  int i;

  /* there will be two more args than argc since we will be adding a
     -H and a hostname */
  test->argc = argc + 2;
  /* there is always at least one thing in argv, the program name */
  test->argv[0] = strdup(argv[0]);

  test->argv[1] = strdup("-H");
  test->argv[2] = strdup(hostname);

  for (i = 1; i < argc; i++) {
    test->argv[i+2] = strdup(argv[i]);
  }
}

uint32_t
alloc_test_structs_command(int argc, char *argv[], test_t **head)
{
  test_t *curr;
  test_t *last;
  char *hostlist[64]; /* This really should use a #define - perhaps
			 the maximum number of threads per process or
			 something?  */
  uint32_t num_hosts;
  int i;
  int nargc;

  void *shared_base_ptr;

  if (debug) {
    fprintf(where,
	    "alloc_test_structs_command called with arrc %d and head %p\n",
	    argc,
	    *head);
    fflush(where);
  }

  num_hosts = make_hostlist(argc, argv, &nargc, hostlist);

  if (debug) {
    fprintf(where,
	    "after make_hostlist nargc is %d hostlist[0] is %s numhost %d \n",
	    nargc,hostlist[0],num_hosts);
    fflush(where);
  }

  /* now that we know the number of test instances, we know how much
     "shared memory" we need for the test. so, open a file, truncated
     to the apropriate size, and mmap it into the process space. this
     will be shared whether we fork or create a thread.  */

  shared_base_ptr = allocate_shared_memory(sizeof(test_t) * num_hosts,
					   "/tmp/netperf_shared_memory");

  assert(shared_base_ptr != NULL);

  *head = curr = (test_t *)shared_base_ptr;

  if (debug) {
    fprintf(where,"allocated first test_t at %x\n",curr);
    fflush(where);
  }

  init_test_globals(curr);
  curr->thread_num = 1;
  copy_args(nargc,argv,curr,hostlist[0]);
  scan_cmd_line(curr);


  for (i = 2; i<= num_hosts; i++) {
    last = curr;
    curr += 1; /* REMEMBER! this is pointer arithmatic, the compiler
		  knows how big a test_t is and we add one test_t,
		  *NOT* sizeof(test_t)...silly rick, pointers are for
		  kids... */

    if (debug) {
      fprintf(where,
	      "allocated another test_t at %x\n",curr);
      fflush(where);
    }

    init_test_globals(curr);
    curr->thread_num = i;
    copy_args(nargc,argv,curr,hostlist[i-1]);
    scan_cmd_line(curr);
    last->next = curr;

  }

  return(num_hosts);
}

uint32_t
alloc_test_structs_file(char *testfile, test_t **head)
{
  test_t *temp;

  printf("alloc_test_structs_file called with %s\n",testfile);
  printf("alloc_test_structs_file called with head %x\n",*head);
  temp = (test_t *)malloc(sizeof(test_t));

  if (temp != NULL) {
    *head = temp;
    temp->test_length = 10;
  }
  else {
    printf("Malloc failed\n");
    exit(-1);
  }

  return(1);
}

#ifdef notdef
void
thread_busy_work(test_t *test)
{
  int32_t i;

#ifdef DEBUG
  if (test == NULL) {
    fprintf(where,
	    "Null test pointer to thread_busy_work!");
    exit(-1);
  }

  printf("Hello there, I am thread %d given a test_t of %x\n",
	 test->thread_num,test);
  for (i = 0; i < test->argc; i++) {
    printf("Thread %d with argv[%d] %s \n",
	 test->thread_num,
	 i,
	 test->argv[i]);
  }
#endif /* DEBUG */

  sleep(test->test_length);

  printf("Now I will attempt to get through the barrier\n");
  
  i = barrier_wait(&netperf_barrier);

  if (i != 0) printf("Well, something was bad with the barrier\n");

  pthread_exit(0);
}
#endif /* notdef */

/* this routine will scan the argv stored in "test", set the "global"
   variables and then invoke the apropriate test-specific command-line
   scaning routine. some "global" variables are per-test, some are
   truely global - at least at this point. raj 1/98 */

void
scan_cmd_line(test_t *test)
{
  /* WARNING!!! getopt is *not* threadsafe - only call this routine
     from within the main thread, or nastiness will result. also,
     since we are calling this routine many times, we need to "reset"
     optind each time we enter this routine. */
  extern int	optind;           /* index of first ungot arg 	*/
  extern char	*optarg;	  /* pointer to option string	*/
  
  int		c;
  
  char	arg1[BUFSIZ],
        arg2[BUFSIZ];
  
  /* Go through all the command line arguments and break them */
  /* out. For those options that take two parms, specifying only */
  /* the first will set both to that value. Specifying only the */
  /* second will leave the first untouched. To change only the */
  /* first, use the form first, (see the routine break_args.. */

  optind = 1;

#ifdef DEBUG
  printf("in scan_cmd_args for thread %d optind is %d\n",
	 test->thread_num,optind);
#endif /* DEBUG */

  while ((c = getopt(test->argc, test->argv, GLOBAL_CMD_LINE_ARGS)) != EOF) {

#ifdef DEBUG
    printf("thread %d option %c\n",test->thread_num,c);
#endif /* DEBUG */

    switch (c) {
    case '?':	
    case 'h':
      print_netperf_usage();
      exit(1);
    case 'a':
      /* set local alignments */
      break_args(optarg,arg1,arg2);
      if (arg1[0]) {
	test->local_send_align = convert(arg1);
      }
      if (arg2[0])
	test->local_recv_align = convert(arg2);
      break;
    case 'A':
      /* set remote alignments */
      break_args(optarg,arg1,arg2);
      if (arg1[0]) {
	test->remote_send_align = convert(arg1);
      }
      if (arg2[0])
	test->remote_recv_align = convert(arg2);
      break;
    case 'd':
      debug++;
      break;
    case 'D':
#if (defined INTERVALS) && (defined __hpux)
      demo_mode++;
#else /* INTERVALS __hpux */
      printf("Sorry, Demo Mode requires -DINTERVALS compilation \n");
      printf("as well as a mechanism to dynamically select syscall \n");
      printf("restart or interruption. I only know how to do this \n");
      printf("for HP-UX. Please examine the code in netlib.c:catcher() \n");
      printf("and let me know of more standard alternatives. \n");
      printf("                             Rick Jones <raj@cup.hp.com>\n");
      exit(1);
#endif /* INTERVALS __hpux */
      break;
    case 'f':
      /* set the thruput formatting. we need to verify that the format
         character is a valid one. we will ignore any NLS issues */
      if ((*optarg == 'k') ||
	  (*optarg == 'K') ||
	  (*optarg == 'm') ||
	  (*optarg == 'M') ||
	  (*optarg == 'g') ||
	  (*optarg == 'G') ||
	  (*optarg == 't')) {
	test->format_units = *optarg;
	break;
      }
      else {
	fprintf(stderr,"Sorry, %c is not a valid format unit");
	fprintf(stderr," please use k, K, m, M, g, G, or t intstead\n.");
	exit(-1);
      }
    case 'F':
      /* set the fill_file variable for pre-filling buffers */
      strcpy(test->fill_file,optarg);
      break;
    case 'i':
      /* set the iterations min and max for confidence intervals */
      break_args(optarg,arg1,arg2);
      if (arg1[0]) {
	iteration_max = convert(arg1);
      }
      if (arg2[0] ) {
	iteration_min = convert(arg2);
      }
      /* silently limit maximum to 30 iterations */
      if(iteration_max>30) iteration_max=30;
      if(iteration_min>30) iteration_min=30;
      break;
    case 'I':
      /* set the confidence level (95 or 99) and width */
      break_args(optarg,arg1,arg2);
      if (arg1[0]) {
	confidence_level = convert(arg1);
      }
      if((confidence_level != 95) && (confidence_level != 99)){
	printf("Only 95%% and 99%% confidence level is supported\n");
	exit(1);
      }
      if (arg2[0] ) {
	interval = (double) convert(arg2)/100;
      }
      break;
    case 'k':
      /* local dirty and clean counts */
#ifdef DIRTY
      break_args(optarg,arg1,arg2);
      if (arg1[0]) {
	test->loc_dirty_count = convert(arg1);
      }
      if (arg2[0] ) {
	test->loc_clean_count = convert(arg2);
      }
#else
      printf("I don't know how to get dirty.\n");
#endif /* DIRTY */
      break;
    case 'K':
      /* remote dirty and clean counts */
#ifdef DIRTY
      break_args(optarg,arg1,arg2);
      if (arg1[0]) {
	test->rem_dirty_count = convert(arg1);
      }
      if (arg2[0] ) {
	test->rem_clean_count = convert(arg2);
      }
#else
      printf("I don't know how to get dirty.\n");
#endif /* DIRTY */
      break;
    case 'n':
      shell_num_cpus = atoi(optarg);
      break;
    case 'o':
      /* set the local offsets */
      break_args(optarg,arg1,arg2);
      if (arg1[0])
	test->local_send_offset = convert(arg1);
      if (arg2[0])
	test->local_recv_offset = convert(arg2);
      break;
    case 'O':
      /* set the remote offsets */
      break_args(optarg,arg1,arg2);
      if (arg1[0]) 
	test->remote_send_offset = convert(arg1);
      if (arg2[0])
	test->remote_recv_offset = convert(arg2);
      break;
    case 'P':
      /* to print or not to print, that is */
      /* the header question */
      test->print_headers = convert(optarg);
      break;
    case 't':
      /* set the test name */
      strncpy(test->test_name,optarg, NETPERF_TEST_MAX);
      break;
    case 'W':
      /* set the "width" of the user space data buffer ring. This will */
      /* be the number of send_size buffers malloc'd in the tests */  
      break_args(optarg,arg1,arg2);
      if (arg1[0]) 
	test->send_width = convert(arg1);
      if (arg2[0])
	test->recv_width = convert(arg2);
      break;
    case 'l':
      /* assume a timed test */
      test->test_length = convert(optarg);
      break;
    case 'v':
      /* say how much to say */
      test->verbosity = convert(optarg);
      break;
    case 'c':
      /* measure local cpu usage please. */
      local_cpu_rate = (float)atof(test->argv[optind]);
      local_cpu_usage = 1;
      break;
    case 'C':
      /* measure remote cpu usage please */
      test->remote_cpu_rate = (float)atof(test->argv[optind]);
      test->remote_cpu_usage++;
      break;
    case 'p':
      /* specify an alternate port number */
      test->control_port = (short) convert(optarg);
      break;
    case 'H':
      /* save-off the host identifying information */
      strncpy(test->remote_host,optarg,NETPERF_HOST_MAX);
      break;
    case 'w':
      /* We want to send requests at a certain wate. */
      /* Remember that there are 1000000 usecs in a */
      /* second, and that the packet rate is */
      /* expressed in packets per millisecond. */
#ifdef INTERVALS
      test->interval_wate  = convert(optarg);
      test->interval_usecs = interval_wate * 1000;
#else
      printf("Packet rate control is not compiled in.\n");
#endif
      break;
    case 'b':
      /* we want to have a burst so many packets per */
      /* interval. */
#ifdef INTERVALS
      test->interval_burst = convert(optarg);
#else
      printf("Packet burst size is not compiled in. \n");
#endif /* INTERVALS */
      break;
    };
  }

  if (debug) {
    fprintf(where,
	    "thread %d, test_name %s num %d optind %d\n",
	    test->thread_num,
	    test->test_name,
	    test->test_num,
	    optind);
    fflush(where);
  }

  /* we have encountered a -- in global command-line */
  /* processing and assume that this means we have gotten to the */
  /* test specific options. this is a bit kludgy and if anyone has */
  /* a better solution, i would love to see it. in the past, we
     checked first to see if there were any test-specific arguments,
     but now we will always call the routine because that scanning
     routine will also be allocating the test-specific area of the
     test_t structure. raj 1/98 */

  if (strcmp(test->test_name,"TCP_STREAM") == 0) 
    test->test_num = TCP_STREAM;
  else if (strcmp(test->test_name,"TCP_RR") == 0) 
    test->test_num = TCP_RR;
  else if (strcmp(test->test_name,"TCP_CRR") == 0) 
    test->test_num = TCP_CRR;
#ifdef DO_1644
  else if (strcmp(test->test_name,"TCP_TRR") == 0)
    test->test_num = TCP_TRR;
#endif /* DO_1644 */
  else if (strcmp(test->test_name,"UDP_STREAM") == 0)
    test->test_num = UDP_STREAM;
  else if (strcmp(test->test_name,"UDP_RR") == 0)
    test->test_num = UDP_RR;
  
#ifdef DO_DLPI
  else if (strcmp(test->test_name,"DLCO_RR") == 0)
    test->test_num = DLCO_RR;
  else if (strcmp(test->test_name,"DLCL_RR") == 0)
    test->test_num = DLCL_RR;
  else if (strcmp(test->test_name,"DLCO_STREAM") == 0)
    test->test_num = DLCO_STREAM;
  else if (strcmp(test->test_name,"DLCL_STREAM") == 0)
    test->test_num - DLCL_STREAM;
#endif /* DO_DLPI */
  
#ifdef DO_XTI
  else if (strcmp(test->test_name,"XTI_TCP_RR") == 0)
    test->test_num = XTI_TCP_RR;
  else if (strcmp(test->test_name,"XTI_TCP_STREAM") == 0)
    test->test_num = XTI_TCP_STREAM;
  else if (strcmp(test->test_name,"XTI_UDP_RR") == 0)
    test->test_num = XTI_UDP_RR;
  else if (strcmp(test->test_name,"XTI_UDP_STREAM") == 0)
    test->test_num = XTI_UDP_STREAM;
#endif /* DO_XTI */
  
#ifdef DO_IPV6
  else if (strcmp(test->test_name,"TCPIPV6_RR") == 0)
    test->test_num = TCPIPV6_RR;
  else if(strcmp(test->test_name,"TCPIPV6_CRR") == 0)
    test->test_num = TCPIPV6_CRR;
  else if (strcmp(test->test_name,"TCPIPV6_STREAM") == 0)
    test->test_num = TCPIPV6_STREAM;
  else if (strcmp(test->test_name,"UDPIPV6_RR") == 0)
    test->test_num = UDPIPV6_RR;
  else if (strcmp(test->test_name,"UDPIPV6_STREAM") == 0)
    test->test_num = UDPIPV6_STREAM;
#endif /* DO_IPV6 */
  
#ifdef DO_DNS
  else if (strcmp(test->test_name,"DNS_RR") == 0)
    test->test_num = DNS_RR;
#endif /* DO_DNS */

#ifdef DO_FTP
  else if (strcmp(test->test_name,"FTP_DOWNLOAD") == 0)
    test->test_num = FTP_DOWNLOAD;
#endif /* DO_FTP */

  /* now we would make a dynamic procedure call with a function
     pointer pulled from a switch table. that procedure call would
     then scan the test-specific command-line arguments and place
     them in a test-specific section of the test structure. */
  
  if (debug) {
    fprintf(where,
	    "aboun to scan with test %d and func %d\n",
	    test->test_num,
	    SCAN);
    fflush(where);
  }

  netperf_switch[test->test_num][SCAN](test);

  if (debug) {
    fprintf(where,"after scanning thread %d, test_name %s num %d\n",
	    test->thread_num,
	    test->test_name,
	    test->test_num);
    fflush(where);
  }

}


void
main(int argc, char *argv[])
{
  uint32_t  num_test_threads;
  test_t    *head_test_struct = NULL;
  test_t    *curr_test_struct = NULL;
  int       ret_val;
  int       i;


  netlib3_init();

  /* the first thing we check for is whether or not the command lines
     are supposed to come form the command line (homogenous test) or
     from a file of command lines (the only way to do a heterogeneous
     test. the format of a netperf test with commands from a file
     would be:
     $ netperf3 file <foo>
     where file foo contains the commands
     */

  if ((argc >= 3) && (strcasecmp("file",argv[1]) == 0)) {
    num_test_threads = alloc_test_structs_file(argv[2],
					       &head_test_struct);
  }
  else {
    num_test_threads = alloc_test_structs_command(argc,
						  argv,
						  &head_test_struct);
  }

  /* by this point, we have all the test_structs created, and so
     should know how many threads there are to syncronize. so we can
     initialize the barrier */

  if (debug) {
    fprintf(where,
	    "num_test_threads is %d head is %x\n",
	    num_test_threads,
	    head_test_struct);
    fflush(where);
  }

  curr_test_struct = head_test_struct;

  /* we let the test threads play amongst themselves, and use things
     like wait/pthread_join to sync-up with them when they are
     done. that way, when confidence intervals are being measured, we
     don't have to know anything about it to re-init their barriers
     and such in the middle of the test. That leaves this main
     "thread" free to do other nefarious things. raj 2/98 */
  ret_val = barrier_init(netperf_barrier,num_test_threads);
  ret_val = barrier_init(netperf_stop_barrier,num_test_threads);

  if (debug) {
    fprintf(where,"Barriers initialized, starting threads\n");
    fflush(where);
  }

  for (i = 0; i < num_test_threads; i++) {
    /* before we create the thread, establish the control connection
       for it. i was not sure exactly where I wanted to do this, but
       figured that it was most "modular" to have this outisde of any
       test-specific code, so the best place to do it was in netperf's
       main thread. I suspect that I really should have some better
       clean-up code in the event of a control socket creation
       failure...especially for the discrete processes case raj 1/98
       */ 

    curr_test_struct->control_sock = 
      establish_control(curr_test_struct->remote_host,
			curr_test_struct->control_port);

    /* ok, now that we have a control connection, go ahead and create
       the "thread" */

    start_worker(curr_test_struct,
		 (void *(*)())netperf_switch[curr_test_struct->test_num][SEND],
		 (void *)curr_test_struct,
		 0 /* magic number - don't detach the "thread" */);

    curr_test_struct = curr_test_struct->next;
  }

  /* wait for the test completion */
  wait_for_workers(head_test_struct);

  /* now we want to print the results */
  curr_test_struct = head_test_struct;

  for (i = 0; i < num_test_threads; i++) {
    netperf_switch[curr_test_struct->test_num][PRINT](curr_test_struct);
    curr_test_struct = curr_test_struct->next;
  }
}
