#include "nettypes.h"

#define SOCKETS_ARGS "DhH:L:m:M:p:P:r:s:S:w:"

/* at some point in the future we may get a bit fancier and have
   different sets of test-specific parms for each test within a suite,
   but for now we will have an amalgam just as in netperf 2.1. */ 

typedef struct bsd_test_parms {
  char test_dest[NETPERF_HOST_MAX];
  char test_source[NETPERF_HOST_MAX];
  int32_t local_socket_send;
  int32_t local_socket_recv;
  int32_t local_nodelay;
  int32_t send_size;
  int32_t request_size;
  int32_t local_watermark;
  uint16_t local_port_min; /* the minimum and maximum "client" port
			     numbers for the "connect/close" tests */
  uint16_t local_port_max;
  uint16_t local_port_num; 
  uint16_t remote_port_num;
  int32_t remote_socket_send;
  int32_t remote_socket_recv;
  int32_t remote_nodelay;
  int32_t recv_size;
  int32_t response_size;
  int32_t remote_watermark;
} bsd_test_settings;

typedef struct bsd_test_res {
  /* we have this here so we can know what things became without
     forcing extra setsockpt calls when we ask for defaults "value 0"
     and then overwrite the result with a getsockopt, causing a later
     iteration to think we were not asking for the defaults */
  bsd_test_settings final_settings;
  uint64_t bytes_received;
  uint32_t num_sends;
  uint32_t num_receives;
  uint32_t segment_size; /* really only valid for TCP tests */
} bsd_test_results;

/* This is admittedly ugly, but necessary for my sanity and to make
   sure that when we change the sending side, we change the receiving
   side as well. */

/* sss = socket send size
   srs = socket recv size
   rs  = receive size
   pn  = port number
   nd  = nodelay
   rwm = recieve watermark
   td  = test destination
   */

#define TCP_STREAM_REQ_COMM \
"sss %d srs %d rs %d pn %hu nd %d rwm %d td %s end"

/* append the "global" buffer settings to the various TCP_STREAM
   settings to arrive at the TCP_STREAM_REQ */

#define TCP_STREAM_REQ NETPERF_BUF_SETTINGS " " TCP_STREAM_REQ_COMM

#define TCP_STREAM_RSP TCP_STREAM_REQ_COMM

/* byr  - bytes received
   nrc  - number of receive calls
   tim  - elapsed time
   sdm  - service demand
   mth  - method used to measure CPU
   ncp  - number of CPU's
   */

#define TCP_STREAM_RES "byr %lg nrc %d tim %g sdm %g mth %d ncp %d end"
