#include "nettypes.h"

#define DNS_ARGS "f:hH:"

typedef struct dns_test_parms {
  char test_dest[NETPERF_HOST_MAX];
  char request_file[PATH_MAX];
  int32_t num_rr;
} dns_test_settings;

typedef struct dns_test_res {
  uint32_t num_trans;
  float    elapsed_time;
  dns_test_settings final_settings;
} dns_test_results;

/* this is the definition of the strucuture used to hold the reqeust
   info from the request file */

typedef struct dns_request_struct {
  struct dns_request_struct *next;
  char *name;
  int class;
  int type;
  int success;
} dns_request_t;

/* these are essentially the "packet formats" for the DNS test control
   messages. everthing is passed about as ascii to kludge around
   issues of bit and byte order and issues with differing record
   packet and fundamental data type sizes. */

/* len = the length of the test in seconds
   num = number of RR's in the test list
   src = the name of the file with the list of RR's
   dst = the name of the name server
 */

#define DNS_RR_REQ \
"len %d num %d src %s dst %s end"

#define DNS_RR_RSP \
"num %d src %s dst %s end"

/* it is going to be rather inefficient at the startup I suspect, but
   at the moment, we will send the RR's to test to the remote side one
   at a time. should it prove to be a problem, we can always make this
   a bulk-transfer at a later time raj 3/98 */

/* nam = the name of the resource record we are going to request
   typ = what type it should be - A, MX, etc
   fnd = should the request be found by the server or not

#define DNS_RR_DEF \
"nam %s typ %s fnd %d end"

/* trn = the number of transactions completed in the test
   tim = the actual length of the test.
   */

#define DNS_RR_RES \
"trn %d tim %g end"
