/*
 *	ConnectOutEvent.java		2002/11/17
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.core;

/** 
 * The ConnectOutEvent class is an Event sent by the UI to set up a Connection.
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
public class ConnectOutEvent extends OutEvent
{
	/** username to connect as */
	private String _strUsername;
	/** server name to connect to */
	private String _strHost;
	/** port number to connect to */
	private int _iPort;
	
	/**
	 * Constructor sets up the member vars
	 * @param strUsername user name
	 * @param strHost host name
	 * @param iPort port
	 */
	public ConnectOutEvent( String strUsername, String strHost, int iPort )
	{
		super( null );	// no destination entity (handled by Main class)
		_strUsername = strUsername;
		_strHost = strHost;
		_iPort = iPort;
	}

	/** Retrieve the username
	 * @return username
	 */
	public String getUsername()
	{
		return _strUsername;
	}
	
	/** Retrieve the server name
	 * @return server name
	 */
	public String getHost()
	{
		return _strHost;
	}

	/** Retrieve the port 
	 * @return port
	 */
	public int getPort()
	{
		return _iPort;
	}
}
