/*
 *	UIHandler.java		2002/10/31
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.core;

/** 
 * The UIHandler interface provides methods to get and put events to specific UI Handler
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
public interface UIHandler
{
	/**
	 * putEvent sends an event to the Handler.
	 * @param event the event to send.
	 */
	public void putEvent( InEvent event );

	/**
	 * getEvent reads an event from the Handler - will block until there is one to receive.
	 * @return the event received.
	 */
	public OutEvent getEvent();
}
