/*
 *	SILCConnectionAuthPayload.java		2002/11/14
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;
import java.nio.ByteBuffer;
import com.alistairphipps.util.Hex;

/** Class to implement a Connection Authentication payload
 *
 * @author Alistair K Phipps
 * @version 20021114
 */
public class SILCConnectionAuthPayload extends SILCPayload
{
	/** Type of connection */
	short _sConnectionType;
	
	/** Authentication data */
	private byte[] _ylAuthData;
	
	/** Constructor to set up the payload with default values.
	 */
	public SILCConnectionAuthPayload() 
	{
		_sConnectionType = SILCConnectionType.CLIENT;
		_ylAuthData = new byte[0];	// no authentication data by default
	}

	/** Constructor to set up the payload information from a bytelist
	 * @param yl List of bytes forming received payload
	 */
	public SILCConnectionAuthPayload( byte[] yl )
	{
		ByteBuffer yb = ByteBuffer.wrap( yl );
		short sPayloadLength = yb.getShort();
		assert( sPayloadLength == yl.length );
		_sConnectionType = yb.getShort();
		_ylAuthData = new byte[ sPayloadLength - s_emptyLength ];
		yb.get( _ylAuthData );
	}
	
	// doc inherited
	public byte[] toByteList()
	{
		ByteBuffer yb = ByteBuffer.allocate( s_emptyLength + _ylAuthData.length );
		yb.putShort( (short)( s_emptyLength + _ylAuthData.length ) );
		yb.putShort( _sConnectionType );
		yb.put( _ylAuthData );
		return yb.array();
	}

	// doc inherited
	public String toString()
	{
		String strRet;
		strRet = "Connection type: " + SILCConnectionType.toString( _sConnectionType );
		strRet += "Authentication data: " + Hex.toString( _ylAuthData );
		return strRet;
	}

	public boolean isList()
	{
		return false;
	}

	private short s_emptyLength = 4;
}

