/*
 *	SILCConnectionType.java		2002/11/14
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;

/** Defines different connection Types that can be sent/received.
 *
 * @author Alistair K Phipps
 * @version 20021114
 */
public class SILCConnectionType
{
	/** identifies a client connection */
	public static final short CLIENT = 1;
	/** identifies a server connection */
	public static final short SERVER = 2;
	/** identifies a router connection */
	public static final short ROUTER = 3;
	
	public static String toString( short s )
	{
		switch( s )
		{
		case CLIENT:
			return "Client";
		case SERVER:
			return "Server";
		case ROUTER:
			return "Router";
		default:
			return "Unknown";
		}
	}
}
