/*
 *	SILCPubKeyType.java		2002/11/11
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;

/** Defines different Public Key Types that can be sent/received.
 *
 * @author Alistair K Phipps
 * @version 20021111
 */
public class SILCPubKeyType
{
	/** SILC-style */
	public static final short SILC = 1;
	/** SSH2-style */
	public static final short SSH2 = 2;
	/** X.509 v3 cert */
	public static final short X509 = 3;
	/** OpenPGP cert */
	public static final short OPENPGP = 4;
	/** SPKI cert */
	public static final short SPKI = 5;
	
	public static String toString( short s )
	{
		switch( s )
		{
		case SILC:
			return "SILC";
		case SSH2:
			return "SSH2";
		case X509:
			return "X.509 v3";
		case OPENPGP:
			return "OpenPGP";
		case SPKI:
			return "SPKI";
		default:
			return "Unknown";
		}
	}
}

