/*
 *	SILCStatusType.java		2002/11/13
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;

/** Defines different Status Types that can be sent/received.
 *
 * @author Alistair K Phipps
 * @version 20021113
 */
public class SILCStatusType
{
	/** Everything went OK. */
	public static final byte OK = 0;

	/** Start of the list.  There will be several replies and this is the start of the list. */
	public static final byte LIST_START = 1;

	/** Item in the list.  This is one of the items in the list but not the first or last. */
	public static final byte LIST_ITEM = 2;

	/** End of the list.  There were several replies and this is the last of the list. */
	public static final byte LIST_END = 3;

	/** No such nickname. */
	public static final byte ERR_NO_SUCH_NICK = 10;

	/** No such channel. */
	public static final byte ERR_NO_SUCH_CHANNEL = 11;

	/** No such server. */
	public static final byte ERR_NO_SUCH_SERVER = 12;

	/** Incomplete registration information. */
	public static final byte ERR_INCOMPLETE_INFORMATION = 13;

	/** No recipient given. */
	public static final byte ERR_NO_RECIPIENT = 14;

	/** Unknown command. */
	public static final byte ERR_UNKNOWN_COMMAND = 15;

	/** Wildcards cannot be used. */
	public static final byte ERR_WILDCARDS = 16;

	/** No client ID given. */
	public static final byte ERR_NO_CLIENT_ID = 17;
	
	/** No channel ID given. */
	public static final byte ERR_NO_CHANNEL_ID = 18;

	/** No server ID given. */
	public static final byte ERR_NO_SERVER_ID = 19;

	/** Bad client ID. */
	public static final byte ERR_BAD_CLIENT_ID = 20;

	/** Bad channel ID. */
	public static final byte ERR_BAD_CHANNEL_ID = 21;

	/** No such client ID. */
	public static final byte ERR_NO_SUCH_CLIENT_ID = 22;
	
	/** No such channel ID. */
	public static final byte ERR_NO_SUCH_CHANNEL_ID = 23;

	/** Nickname in use.  More than the maximum number of nicknames the same as yours already in use. */
	public static final byte ERR_NICKNAME_IN_USE = 24;

	/** You are not on the channel a command was specified for. */
	public static final byte ERR_NOT_ON_CHANNEL = 25;

	/** Requested target client not on requested channel. */
	public static final byte ERR_USER_NOT_ON_CHANNEL = 26;

	/** User already on channel invited to. */
	public static final byte ERR_USER_ON_CHANNEL = 27;

	/** You have not registered with server. */
	public static final byte ERR_NOT_REGISTERED = 28;

	/** Not enough parameters. */
	public static final byte ERR_NOT_ENOUGH_PARAMS = 29;

	/** Too many parameters. */
	public static final byte ERR_TOO_MANY_PARAMS = 30;

	/** Permission denied. */
	public static final byte ERR_PERM_DENIED = 31;

	/** Banned from server. */
	public static final byte ERR_BANNED_FROM_SERVER = 32;

	/** Incorrect password to join channel. */
	public static final byte ERR_BAD_PASSWORD = 33;

	/** Channel full so can't join. */
	public static final byte ERR_CHANNEL_IS_FULL = 34;

	/** Not invited to channel so can't join. */
	public static final byte ERR_NOT_INVITED = 35;

	/** Can't join channel as are banned. */
	public static final byte ERR_BANNED_FROM_CHANNEL = 36;

	/** Mode provided by client unknown to server. */
	public static final byte ERR_UNKNOWN_MODE = 37;

	/** Cannot change mode for other users. */
	public static final byte ERR_NOT_YOU = 38;

	/** Permission denied as not channel op. */
	public static final byte ERR_NO_CHANNEL_PRIV = 39;

	/** Permission denied as not channel founder. */
	public static final byte ERR_NO_CHANNEL_FOPRIV = 40;

	/** Permission denied as not server operator. */
	public static final byte ERR_NO_SERVER_PRIV = 41;

	/** Permission denied as not SILC (router) operator. */
	public static final byte ERR_NO_ROUTER_PRIV = 42;

	/** Bad nickname - contained illegal characters. */
	public static final byte ERR_BAD_NICKNAME = 43;

	/** Bad channel name. */
	public static final byte ERR_BAD_CHANNEL = 44;

	/** Authentication failed. */
	public static final byte ERR_AUTH_FAILED = 45;

	/** Algorithm not supported. */
	public static final byte ERR_UNKNOWN_ALGORITHM = 46;

	/** No such server ID. */
	public static final byte ERR_NO_SUCH_SERVER_ID = 47;

	/** No more resources available. */
	public static final byte ERR_RESOURCE_LIMIT = 48;

	/** Service does not exist. */
	public static final byte ERR_NO_SUCH_SERVICE = 49;

	/** Not been authenticated. */
	public static final byte ERR_NOT_AUTHENTICATED = 50;

	/** Bad server ID. */
	public static final byte ERR_BAD_SERVER_ID = 51;

	/** Key exchange failed. */
	public static final byte ERR_KEY_EXCHANGE_FAILED = 52;

	/** Bad version (protocol or software). */
	public static final byte ERR_BAD_VERSION = 53;

	public static String toString( byte y )
	{
		switch( y )
		{
		case OK:
			return "OK";
		case LIST_START:
			return "Start item of List";
		case LIST_ITEM:
			return "Item in list";
		case LIST_END:
			return "End item of list";
		case ERR_NO_SUCH_NICK:
			return "No such nickname";
		case ERR_NO_SUCH_CHANNEL:
			return "No such channel";
		case ERR_NO_SUCH_SERVER:
			return "No such server";
		case ERR_INCOMPLETE_INFORMATION:
			return "Incomplete registration information";
		case ERR_NO_RECIPIENT:
			return "No recipient given";
		case ERR_UNKNOWN_COMMAND:
			return "Unknown command";
		case ERR_WILDCARDS:
			return "Wildcards cannot be used";
		case ERR_NO_CLIENT_ID:
			return "No client ID given";
		case ERR_NO_CHANNEL_ID:
			return "No channel ID given";
		case ERR_NO_SERVER_ID:
			return "No server ID given";
		case ERR_BAD_CLIENT_ID:
			return "Bad client ID";
		case ERR_BAD_CHANNEL_ID:
			return "Bad channel ID";
		case ERR_NO_SUCH_CLIENT_ID:
			return "No such client ID";
		case ERR_NO_SUCH_CHANNEL_ID:
			return "No such channel ID";
		case ERR_NICKNAME_IN_USE:
			return "Nickname in use too many times";
		case ERR_NOT_ON_CHANNEL:
			return "Not on channel";
		case ERR_USER_NOT_ON_CHANNEL:
			return "That user is not on channel";
		case ERR_USER_ON_CHANNEL:
			return "User already on channel";
		case ERR_NOT_REGISTERED:
			return "Not registered";
		case ERR_NOT_ENOUGH_PARAMS:
			return "Not enough parameters";
		case ERR_TOO_MANY_PARAMS:
			return "Too many parameters";
		case ERR_PERM_DENIED:
			return "Permission denied";
		case ERR_BANNED_FROM_SERVER:
			return "Banned from server";
		case ERR_BAD_PASSWORD:
			return "Bad password";
		case ERR_CHANNEL_IS_FULL:
			return "Channel is full";
		case ERR_NOT_INVITED:
			return "Not invited to channel";
		case ERR_BANNED_FROM_CHANNEL:
			return "Banned from channel";
		case ERR_UNKNOWN_MODE:
			return "Unknown mode";
		case ERR_NOT_YOU:
			return "Cannot change mode for other users";
		case ERR_NO_CHANNEL_PRIV:
			return "You are not a channel operator";
		case ERR_NO_CHANNEL_FOPRIV:
			return "You are not a channel founder";
		case ERR_NO_SERVER_PRIV:
			return "You are not a server operator";
		case ERR_NO_ROUTER_PRIV:
			return "You are not a SILC operator";
		case ERR_BAD_NICKNAME:
			return "Bad nickname";
		case ERR_BAD_CHANNEL:
			return "Bad channel name";
		case ERR_AUTH_FAILED:
			return "Authentication failed";
		case ERR_UNKNOWN_ALGORITHM:
			return "Algorithm not supported";
		case ERR_NO_SUCH_SERVER_ID:
			return "No such server ID";
		case ERR_RESOURCE_LIMIT:
			return "No more server resources available";
		case ERR_NO_SUCH_SERVICE:
			return "Service does not exist";
		case ERR_NOT_AUTHENTICATED:
			return "You are not authenticated";
		case ERR_BAD_SERVER_ID:
			return "Bad server ID";
		case ERR_KEY_EXCHANGE_FAILED:
			return "Key exchange failed";
		case ERR_BAD_VERSION:
			return "Bad protocol or software version";
		default:
			return "Unknown";
		}
	}
}

