/*
 *	ConnectDlg.java		2002/11/17
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.swingui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/** 
 * The connect dialog for the application
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
public class ConnectDlg extends JDialog
{
	MainFrame _mainframe;
	JTextField _username;
	JTextField _servername;
	JTextField _serverport;
	
	/** Inner class to handle Connect button */
	private class ConnectL implements ActionListener
	{
		public void actionPerformed( ActionEvent e )
		{
			// call back to the main frame with the values entered
			try
			{
				int iPort = Integer.parseInt( _serverport.getText() );
				if( ( iPort < 0 ) || ( iPort > 65535 ) )
					throw new NumberFormatException();
				_mainframe.connect( _username.getText(), _servername.getText(), iPort );
				dispose();	// close dialog
			}
			catch( NumberFormatException n )
			{
				JOptionPane.showMessageDialog( null, "Invalid port number - enter a decimal number between 0 and 65535." );
			}
		}
	}

	/** Inner class to handle Cancel button */
	private class CancelL implements ActionListener
	{
		public void actionPerformed( ActionEvent e )
		{
			dispose(); // close dialog
		}
	}
	
	public ConnectDlg( MainFrame mainframe )
	{
		super( (JFrame)null, "Connect...", true ); // create modal dialog without parent (makes no difference)
		_mainframe = mainframe;
		Container cp = getContentPane();
		cp.setLayout( new GridLayout( 4, 1 ) );

		JPanel p1 = new JPanel( new BorderLayout() );
		p1.add( new JLabel( "User Name:" ), BorderLayout.WEST );
		_username = new JTextField( 30 );
		p1.add( _username, BorderLayout.EAST );
		cp.add( p1 );

		JPanel p2 = new JPanel( new BorderLayout() );
		p2.add( new JLabel( "Server Name:" ), BorderLayout.WEST );
		_servername = new JTextField( 30 );
		p2.add( _servername, BorderLayout.EAST );
		cp.add( p2 );
		
		JPanel p3 = new JPanel( new BorderLayout() );
		p3.add( new JLabel( "Port:" ), BorderLayout.WEST );
		_serverport = new JTextField( 5 );
		p3.add( _serverport, BorderLayout.EAST ); // TODO: move to left-justify
		cp.add( p3 );
		
		JPanel p4 = new JPanel( new BorderLayout() );
		JButton connect = new JButton( "Connect" );
		connect.addActionListener( new ConnectL() );
		JButton cancel = new JButton( "Cancel" );
		cancel.addActionListener( new CancelL() );
		p4.add( connect, BorderLayout.WEST );
		p4.add( cancel, BorderLayout.EAST );
		cp.add( p4 );

		pack();
	}
}
