/*
 *	UBigInteger.java		2002/11/13
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.util;

import java.math.BigInteger;
import java.lang.System;

/** Gives conversions for Unsigned big integers.
 * 
 * @author Alistair K Phipps
 * @version 20021113
 */
public class UBigInteger
{
	
	/** Convert an unsigned byte array (with no leading zero byte) into a positive big integer
	 * @param yl Byte array to convert
	 * @return Positive big integer
	 */
	static public BigInteger fromByteArray( byte[] yl )
	{
		assert( yl.length > 0 );	// must have something in the array
		if( yl[0] < (byte)0x80 )	// if bit 7 is not set, then it will be positive anyway
			return new BigInteger( yl );
		else						// otherwise have to add a leading zero-byte
		{
			byte[] yl2 = new byte[ yl.length + 1 ];
			System.arraycopy( yl, 0, yl2, 1, yl.length );
			return new BigInteger( yl2 );
		}
	}

	/** Convert a big integer into an unsigned byte array (with no leading zero byte)
	 * @param bi Positive big integer to output
	 * @return Byte array
	 */
	static public byte[] toByteArray( BigInteger bi )
	{
		assert( bi.compareTo( BigInteger.valueOf( 0 ) ) >= 0 );	// big integer must be +ve to do this
		// convert to byte array
		byte[] yl = bi.toByteArray();
		// but this might have a leading zero-byte if the first "digit" is >= 0x7F - strip it if it does
		if( yl[0] != (byte)0 )
			return yl;
		byte[] yl2 = new byte[ yl.length - 1 ];
		System.arraycopy( yl, 1, yl2, 0, yl2.length );
		return yl2;
	}
}
