/*
(C) 1998 Patrick Lambert <drow@fastethernet.net>

This program is under GPL. See README.

This program is distributed without ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

Latest version of InstallScript is available at:
http://devplanet.fastethernet.net
*/

#include <stdio.h>
#include <gtk/gtk.h>
char value[255];
char *lindex(char *input_string, int word_number);
char *lrange(char *input_string, int starting_at);
GtkWidget *entry_box, *window, *box, *label, *button1, *button2, *hbox,
*separator, *vbox, *path, *text, *vscrollbar, *table, *vbox2;
FILE *fd;

char *lindex(char *input_string, int word_number)
{
 char *tokens[1024];
 static char tmpstring[1024];
 int i;
 strcpy(tmpstring,input_string);
 tokens[i=0] = strtok(tmpstring, " ");
 while ((tokens[++i] = strtok(NULL, " ")));
 tokens[i] = NULL;
 return(tokens[word_number]);
}

char *lrange(char *input_string, int starting_at)
{
 char *tokens[1024];
 static char tmpstring[1024]="";
 int i;
 char out_string[1024]="";
 strcpy(out_string,"");
 if(input_string==NULL) {
  strcpy(out_string," ");
  strcat(out_string,NULL);   
  return (char *)out_string; }
 strcpy(tmpstring,input_string);
 tokens[i=0] = strtok(tmpstring, " ");
 while((tokens[++i] = strtok(NULL, " ")));
 tokens[i] = NULL;
 i++;
 if(i<starting_at) {
  return (char *)""; }
 while(tokens[starting_at] != NULL) {
  strcat(out_string,tokens[starting_at]);
  strcat(out_string, " ");
  starting_at++; }
 return (char *)out_string;
}

int destroy_window(GtkWidget *widget, GtkWidget *entry)
{
 gtk_widget_destroy(widget);
 gtk_main_quit();
 exit(-1);
}

int ok_button(GtkWidget *widget, GtkWidget *entry)
{
 FILE *fpg;
 char line[1024],temp[1024];
 strcpy(value,gtk_entry_get_text(GTK_ENTRY(entry_box)));
 sprintf(temp,"mkdir %s >install.log 2>install.log",value);
 system(temp);
 while(fgets(line,1024,fd)!=NULL)
 {
  if(!strcasecmp(lindex(line,0),"COPY:"))
  {
   sprintf(temp,"cp %s %s%s >>install.log 2>>install.log",lindex(line,1),value,lindex(line,2));
   system(temp);
  }
  if(!strcasecmp(lindex(line,0),"MKDIR:"))
  {
   sprintf(temp,"mkdir %s%s >>install.log 2>>install.log",value,lindex(line,1));
   system(temp);
  }
  if(!strcasecmp(lindex(line,0),"EXEC:"))
  {
   sprintf(temp,"%s 2>>install.log\n",lrange(line,1));
   system(temp);
  }
  if(!strcasecmp(lindex(line,0),"PRINT:"))
  {
   printf("%s\n",lrange(line,1));
  }
 }
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 450, 300);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(destroy_window), window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(destroy_window), window);
 gtk_window_set_title (GTK_WINDOW (window), "InstallScript");
 gtk_container_border_width (GTK_CONTAINER (window), 2);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);

 hbox = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);
 
 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (hbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);
 
 text = gtk_text_new (NULL, NULL);
 gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
 gtk_widget_show (text);

 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text));
 gtk_widget_realize (text);

 fpg=fopen("install.log","r");
 while(fgets(line,255,fpg)!=NULL) 
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, line, -1);
 if(fpg!=NULL) fclose(fpg);
 gtk_text_thaw (GTK_TEXT (text));

 vbox2 = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
 gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 0);
 gtk_widget_show (vbox2);

 label = gtk_label_new ("Installation done. This is the install log.");
 gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 button1 = gtk_button_new_with_label ("Quit");
 gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
  GTK_SIGNAL_FUNC(destroy_window), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (vbox2), button1, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button1);
 gtk_widget_show (button1);
 gtk_widget_show (window);
 gtk_main();

 return(FALSE);
}

main(int argc, char *argv[])
{
 int i;
 char string[1024], local[255], local2[255];
 gtk_init(&argc, &argv);
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 450, 300);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);   
 gtk_widget_show (vbox);
 
 box = gtk_vbox_new (FALSE, 0);
 gtk_box_pack_start (GTK_BOX (vbox), box, TRUE, TRUE, 0);
 gtk_widget_show (box);

 gtk_signal_connect (GTK_OBJECT (window), "destroy", GTK_SIGNAL_FUNC(destroy_window), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event", GTK_SIGNAL_FUNC(destroy_window), &window);
 gtk_window_set_title (GTK_WINDOW (window), "InstallScript");
 gtk_container_border_width (GTK_CONTAINER (box), 10);

 fd=fopen("install.script","r");
 if(fd==NULL || fileno(fd)<1)
 {
  printf("Fatal error: No install.script to be found. Exiting...\n");
  exit(0);
 }
 if(fgets(string,1024,fd)==NULL)
 {
  printf("Fatal error: Nothing in script.install. Exiting...\n");
  exit(0);
 }
 if(strcasecmp(lindex(string,0),"TITLE:"))
 {
  printf("Fatal error: script.install is corrupted. Exiting...\n");
  exit(0);
 }
 label = gtk_label_new (lrange(string,1));
 gtk_box_pack_start (GTK_BOX (box), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 fgets(string,1024,fd);
 if(strcasecmp(lindex(string,0),"COMMENTS:"))
 {
  printf("Fatal error: script.install is corrupted. Exiting...\n");
  exit(0);
 }
 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2); 
 gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);
 gtk_widget_show (table);

 text = gtk_text_new (NULL, NULL);
 gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
 gtk_widget_show (text);
 
 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text));
 gtk_widget_realize (text);

 while(fgets(string,1024,fd)!=NULL)
 {
  if(lindex(string,0)!=NULL && !strcasecmp(lindex(string,0),"EOF")) break;
  gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, string, -1);  
 }
 fgets(string,1024,fd);
 if(strcasecmp(lindex(string,0),"PATH:"))
 {
  printf("Fatal error: script.install is corrupted. Exiting...\n");
  exit(0);
 }
 path = gtk_label_new ("Default install path:");
 gtk_box_pack_start (GTK_BOX (box), path, TRUE, TRUE, 0);
 gtk_widget_show (path);

 entry_box = gtk_entry_new ();
 strcpy(local,lindex(string,1));
 gtk_entry_set_text (GTK_ENTRY (entry_box), local);
 gtk_box_pack_start (GTK_BOX (box), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);
 separator = gtk_hseparator_new ();
 gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
 gtk_widget_show (separator);

 hbox = gtk_hbox_new (FALSE, 10); 
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);  
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);  
 gtk_widget_show (hbox);

 button1 = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
  GTK_SIGNAL_FUNC(ok_button), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button1, TRUE, TRUE, 0);
 gtk_widget_show (button1);

 button2 = gtk_button_new_with_label ("Cancel");
 gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
  GTK_SIGNAL_FUNC(destroy_window), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button2, TRUE, TRUE, 0);
 gtk_widget_show (button2);

 gtk_widget_show (window);
 gtk_main();
}
