/*
(C) 1998-99 Patrick Lambert <drow@fastethernet.net>

This program is under the GPL

This program is distributed without ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

Latest version of Socket Script is always available from
http://devplanet.fastethernet.net/sscript.html
*/

#include "config.h"
#include "sscript.h"

#include <string.h>

#ifdef GUI
#ifdef GTK
#include <gtk/gtk.h>
GtkWidget *window;
GtkWidget *vbox, *vbox2, *hbox, *box3;
GtkWidget *text, *text2, *entry_box;
GtkWidget *label;
GtkWidget *table;
GtkWidget *button;
GtkWidget *vscrollbar, *hscrollbar;
GtkWidget *choicebutton[10];
GtkWidget *pixmapwid;
GdkPixmap *pixmap;
GdkBitmap *mask;
GtkStyle *style;

static gushort convert_color(unsigned c)
{
 if (c==0) return(0);
 c *= 257;
 return(c > 0xffff)? 0xffff : c;
}

void extract_color(GdkColor *color, unsigned red, unsigned green, unsigned blue)
{
 color->red = convert_color(red);
 color->green = convert_color(green);
 color->blue = convert_color(blue);
}

int GTK_destroy_widget(GtkWidget *widget, GtkWidget *entry)
{
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_startup_run(GtkWidget *widget, GtkWidget *entry) 
{
 sprintf(queryGlVar,"1 %s ;",gtk_entry_get_text(GTK_ENTRY(entry_box)));
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_startup_help(GtkWidget *widget, GtkWidget *entry)
{
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 help(3,1,NULL,NULL);
 return(FALSE);  
}

int GTK_startup_compose(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(queryGlVar,"2 %s ;",gtk_entry_get_text(GTK_ENTRY(entry_box)));
 gtk_widget_destroy(widget);   
 gtk_main_quit();
 gdk_flush();
 return(FALSE);  
}

int GTK_startup_debug(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(queryGlVar,"3 %s ;",gtk_entry_get_text(GTK_ENTRY(entry_box)));
 gtk_widget_destroy(widget);   
 gtk_main_quit();
 gdk_flush();
 return(FALSE);  
}

int GTK_startup_quit(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(queryGlVar,"4 %s ;",gtk_entry_get_text(GTK_ENTRY(entry_box)));
 gtk_widget_destroy(widget);   
 gtk_main_quit();
 gdk_flush();
 return(FALSE);  
}

void GTK_composer_clear(GtkWidget *widget, GtkWidget *entry)
{
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text), gtk_text_get_length(GTK_TEXT(text)));
}

void GTK_composer_cmd_ok(GtkWidget *widget, GtkWidget *entry)
{
 help(3,2,NULL,gtk_entry_get_text(GTK_ENTRY(entry_box)));
 GTK_destroy_widget(widget, entry);
}

int GTK_composer_cmd_return(char *help_string)
{
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 600, 200);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 vbox = gtk_vbox_new (FALSE, 0);   
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);

 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);
 
 text2 = gtk_text_new (NULL, NULL);
 gtk_text_set_editable (GTK_TEXT (text2), TRUE);
 gtk_text_set_word_wrap(GTK_TEXT (text2), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text2, 0, 1, 0, 1);
 gtk_widget_show (text2);

 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text2)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);

 gtk_text_freeze (GTK_TEXT (text2));
 gtk_widget_realize (text2);
 gtk_text_insert (GTK_TEXT (text2), NULL, &text2->style->black, NULL, help_string, -1);
 gtk_text_thaw (GTK_TEXT (text2));

 hbox = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 button = gtk_button_new_with_label ("Close");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), GTK_OBJECT (window)); 
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);  
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 
 gtk_widget_show (window);
 gtk_main();
 return(0);
}

int GTK_composer_cmd(GtkWidget *widget, GtkWidget *entry)
{
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 gtk_container_border_width (GTK_CONTAINER (window), 0);
 
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);
 
 hbox = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);
 
 label = gtk_label_new ("Which command do you want? (type 'index' for a list)");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (hbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);
 
 vbox2 = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
 gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 0);
 gtk_widget_show (vbox2);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_composer_cmd_ok), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (vbox2), button, TRUE, TRUE, 0);  
 gtk_widget_show (button);

 gtk_widget_show (window);
 gtk_main();
 return(0);
}


void GTK_composer_yes(GtkWidget *widget, GtkWidget *entry)
{
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 exit(0);
}

void GTK_composer_about(GtkWidget *widget, GtkWidget *entry)
{
 GtkWidget *separator;
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 300, 100);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Socket Script Composer - (C) 1998 Patrick Lambert\nSee docs/sscript.doc for more.");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 separator = gtk_hseparator_new();
 gtk_box_pack_start (GTK_BOX (vbox), separator, TRUE, TRUE, 0);
 gtk_widget_show (separator);
 
 hbox = gtk_hbox_new (FALSE, 0);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 button = gtk_button_new_with_label ("Close");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);   
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);   

 gtk_widget_show (window);
 gtk_main();
}

void GTK_composer_help(GtkWidget *widget, GtkWidget *entry)
{
 help(3,2,NULL,"composer");
}

void GTK_composer_lib(GtkWidget *widget, GtkWidget *entry)
{
 help(3,2,NULL,"libraries");
}

void GTK_composer_help_old(GtkWidget *widget, GtkWidget *entry)
{
 GtkWidget *separator;
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 500, 150);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Menus: The menus contain the main Socket Script commands,\n    and add an example when you select one.\n\nNote that all SScript commands aren't in the menus yet, only the main ones.\n");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 separator = gtk_hseparator_new();
 gtk_box_pack_start (GTK_BOX (vbox), separator, TRUE, TRUE, 0);
 gtk_widget_show (separator);
 
 hbox = gtk_hbox_new (FALSE, 0);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 button = gtk_button_new_with_label ("Close");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);   
 gtk_widget_show (button);

 gtk_widget_show (window);
 gtk_main();
}

void GTK_composer_quit(GtkWidget *widget, GtkWidget *entry)
{
 GtkWidget *separator;
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 200, 80);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Quit");
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Are you sure?");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 separator = gtk_hseparator_new();
 gtk_box_pack_start (GTK_BOX (vbox), separator, TRUE, TRUE, 0);
 gtk_widget_show (separator);

 hbox = gtk_hbox_new (FALSE, 0);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 button = gtk_button_new_with_label ("Yes");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_composer_yes), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("No");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);
 gtk_widget_show (window);
 gtk_main();
}

int GTK_text_save(GtkWidget *widget, GtkWidget *entry)
{
 FILE *fpg;
 fpg=fopen((char *)widget,"w");
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0,
  gtk_text_get_length(GTK_TEXT(text))),fpg);
 if(fpg!=NULL) fclose(fpg);  
 gtk_widget_destroy(window);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_composer_save(GtkWidget *widget, GtkWidget *entry)
{
 FILE *fpg;
 fpg=fopen((char *)widget,"w");
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0,
  gtk_text_get_length(GTK_TEXT(text))),fpg);
 fputs("\n",fpg);
 if(fpg!=NULL) fclose(fpg);
 return(TRUE);
}

int GTK_composer_add(GtkWidget *widget, GtkWidget *entry)
{
 char data[255];
 strcpy(data,(char *)widget);
 if(!strcasecmp(data,"server"))
 strcpy(data,"\n# server <ip>\nserver 127.0.0.1 ;\n");
 else if(!strcasecmp(data,"port"))
 strcpy(data,"\n# port <port>\nport 80 ;\n");
 else if(!strcasecmp(data,"debug"))
 strcpy(data,"\n# debug <0|1>\ndebug 0 ;\n");
 else if(!strcasecmp(data,"virtual"))
 strcpy(data,"\n# virtual <0|1>\nvirtual 0 ;\n");
 else if(!strcasecmp(data,"chop"))
 strcpy(data,"\n# chop <0|1>\nchop 0 ;\n");
 else if(!strcasecmp(data,"rread"))
 strcpy(data,"\n# rread <variable number> ;\nrread 100 ;\n");
 else if(!strcasecmp(data,"rwrite"))
 strcpy(data,"\n# rwrite <variable number> ;\nset 100 hello !\nrwrite 100 ;\n");
 else if(!strcasecmp(data,"rdisconnect"))
 strcpy(data,"\n# rdisconnect ;\nrdisconnect ;\n");
 else if(!strcasecmp(data,"include"))
 strcpy(data,"\n# include <name> <cl bin> ;\ninclude hello hello ;\n");
 else if(!strcasecmp(data,"setuserhost"))
 strcpy(data,"\n# setuserhost ;\nsetuserhost ;\n");
 else if(!strcasecmp(data,"setstrictcheck"))
 strcpy(data,"\n# setstrictcheck ;\nsetstrictcheck ;\n");
 else if(!strcasecmp(data,"setstrictwrite"))
 strcpy(data,"\n# setstrictwrite ;\nsetstrictwrite ;\n");
 else if(!strcasecmp(data,"settrace"))
 strcpy(data,"\n# settrace ;\nsettrace ;\n");
 else if(!strcasecmp(data,"setreversechop"))
 strcpy(data,"\n# setreversechop ;\nsetreversechop ;\n");
 else if(!strcasecmp(data,"setservice"))
 strcpy(data,"\n# setservice ;\nsetservice ;\n");
 else if(!strcasecmp(data,"setwindows")) 
 strcpy(data,"\n# setwindows ;\nsetwindows ;\n");  
 else if(!strcasecmp(data,"setsignalsoff")) 
 strcpy(data,"\n# setsignalsoff ;\nsetsignalsoff ;\n");  
 else if(!strcasecmp(data,"setremoteecho")) 
 strcpy(data,"\n# setremoteecho ;\nsetremoteecho ;\n");  
 else if(!strcasecmp(data,"require")) 
 strcpy(data,"\n# require <version> ;\nrequire 18 ;\n");
 else if(!strcasecmp(data,"require-gui"))   
 strcpy(data,"\n# require-gui ;\nrequire-gui ;\n");
 else if(!strcasecmp(data,"version"))   
 strcpy(data,"\n# version ;\nversion ;\n");
 else if(!strcasecmp(data,"run"))
 strcpy(data,"\n# run <variable number> ;\nset 100 my.sh\nrun 100 ;\n");
 else if(!strcasecmp(data,"goto"))
 strcpy(data,"\n# goto <sub name> ;\ngoto my_sub ;\n");  
 else if(!strcasecmp(data,"read"))
 strcpy(data,"\n# read <variable number> ;\nread 100 ;\n");
 else if(!strcasecmp(data,"write"))   
 strcpy(data,"\n# write <string> ;\nwrite Hi $word 100 0 !\n");
 else if(!strcasecmp(data,"print"))
 strcpy(data,"\n# print <string> ;\nprint Thank you for using SScript\n");
 else if(!strcasecmp(data,"save"))      
 strcpy(data,"\n# save <variable number> <file> ;\nsave 100 log.file ;\n");
 else if(!strcasecmp(data,"append"))
 strcpy(data,"\n# append <variable number> <file> ;\nappend 101 log.file ;\n");
 else if(!strcasecmp(data,"rementry"))
 strcpy(data,"\n# rementry <variable number> <file> ;\nrementry 100 database.file ;\n");
 else if(!strcasecmp(data,"remove"))
 strcpy(data,"\n# remove <vairable number> <file> ;\nremove 100 database.file ;\n");
 else if(!strcasecmp(data,"ping"))
 strcpy(data,"\n# ping <remote ip> ;\nping 127.0.0.1 ;\n");
 else if(!strcasecmp(data,"test"))
 strcpy(data,"\n# test <variable number> ;\nset 100 127.0.0.1 80 ;\ntest 100 ;\n");
 else if(!strcasecmp(data,"parse"))
 strcpy(data,"\n# parse [<,<<,>>,>,!,_>,<_] <variable number> <char> ;\nparse < 100 @ ;\n");
 else if(!strcasecmp(data,"dump"))
 strcpy(data,"\n# dump <variable number> ;\nset 100 my.file ;\ndump 100 ;\n");
 else if(!strcasecmp(data,"setmaster"))
 strcpy(data,"\n# setmaster <file containing: <masked nick!user@host> ;> ;\nsetmaster masters.list ;\n");
 else if(!strcasecmp(data,"set"))
 strcpy(data,"\n# set <variable number> <string>\nset 100 hi !\n");
 else if(!strcasecmp(data,"setlogfile"))
 strcpy(data,"\n# setlogfile <filename> ;\nsetlogfile my.log ;\n");
 else if(!strcasecmp(data,"exit"))   
 strcpy(data,"\n# exit ;\nexit ;\n");
 else if(!strcasecmp(data,"saveall"))
 strcpy(data,"\n# saveall <filename> ;\nsaveall file.txt ;\n");
 else if(!strcasecmp(data,"addlog"))
 strcpy(data,"\n# addlog <variable number> ;\nset 100 Starting sub 24\naddlog 100 ;\n");
 else if(!strcasecmp(data,"file")) 
 strcpy(data,"\n# file exist <variable 1> <variable 2> ;\nset 100 my.file\nfile exist 100 101 ;\n");
 else if(!strcasecmp(data,"icmplisten"))
 strcpy(data,"\n# icmplisten <variable number> ;\nicmplisten 100 ;\n");
 else if(!strcasecmp(data,"cl"))
 strcpy(data,"\n# cl <library> <command> <args> ... ;\ncl util crypt 100 101 ;\n");
 else if(!strcasecmp(data,"command"))
 strcpy(data,"\n# command <variable number> ;\nset 100 addlog 101 ;\ncommand 100 ;\n");
 else if(!strcasecmp(data,"background"))
 strcpy(data,"\n# background ;\nbackground ;\n");
 else if(!strcasecmp(data,"rconnect"))
 strcpy(data,"\n# rconnect <variable number> ;\nset 100 127.0.0.1 23 ;\nrconnect 100 ;\n");
 else if(!strcasecmp(data,"endfor"))
 strcpy(data,"\n# endfor <for number> ;\nendfor 1 ;\n");
 else if(!strcasecmp(data,"ask"))
 strcpy(data,"\n# ask <variable number> ;\nask 105 ;\n");
 else if(!strcasecmp(data,"ifmatch"))
 strcpy(data,"\n# ifmatch <variable number> <masked word> <string> ;\nifmatch 100 *user@*.host QUIT : $nick asked me to.\n");
 else if(!strcasecmp(data,"loop"))
 strcpy(data,"\n# loop [start|end] <loop number> ;\nloop start 1 ;\nloop end 1 ;\n");
 else if(!strcasecmp(data,"for"))
 strcpy(data,"\n# for <for number> <start number> to <end number> ;\nfor 1 1 to 100 do\n");
 else if(!strcasecmp(data,"ifword"))
 strcpy(data,"\n# ifword <variable number> <word number> <word> <string>\nifword 100 0 help Here is my help: none.\n");
 else if(!strcasecmp(data,"ifword2"))
 strcpy(data,"\n# ifword2 <variable number> <word number> <word> <word number 2> <word 2> <string>\nifword2 100 0 help 1 commands There is no command available yet.\n");
 else if(!strcasecmp(data,"ifmaster"))
 strcpy(data,"\n# ifmaster <variable number> <word number> <word> <string>\nifmaster 100 3 :raw PRIVMSG $nick :raw is not available\n");
 else if(!strcasecmp(data,"ifmaster2"))
 strcpy(data,"\n# ifmaster2 <variable number> <word number> <word> <word number 2> <word 2> <string>\nifmaster2 100 3 :password 4 ScrtPass PRIVMSG $nick :Auth failed.\n");
 else if(!strcasecmp(data,"?compare"))
 strcpy(data,"\n# ?compare <variable number 1> <variable number 2> <sub name> ;\n?compare 100 101 my_sub ;\n");
 else if(!strcasecmp(data,"?match"))
 strcpy(data,"\n# ?match <variable number 1> <variable number 2> <sub name> ;\n?match 100 101 my_sub ;\n"); 
 else if(!strcasecmp(data,"if"))
 strcpy(data,"\n# if <variable number 1> [<,>,=] <variable number 2> <sub name> ;\nif 100 = 101 my_sub ;\n");
 else if(!strcasecmp(data,"resolve"))
 strcpy(data,"\n# resolve [ip,host] <variable number 1> <variable number 2> ;\nresolve host 100 101 ;\n");
 else if(!strcasecmp(data,"cron"))
 strcpy(data,"\n# cron <command line>\ncron /usr/bin/who\n");
 else if(!strcasecmp(data,"random"))   
 strcpy(data,"\n# random <variable number> <max> ;\nrandom 100 6 ;\n");
 else if(!strcasecmp(data,"udpsend"))
 strcpy(data,"\n# udpsend <variable number> ;\nset 100 127.0.0.1 2000 Hi, this is the sender\nudpsend 100 ;\n");
 else if(!strcasecmp(data,"udplisten"))
 strcpy(data,"\n# udplisten <variable number> <port number> ;\nudplisten 100 2000\n");
 else if(!strcasecmp(data,"raw"))
 strcpy(data,"\n# raw <variable number 1> <number of loops> <variable number 2> ;\nraw 100 1 101 ;\n"); 
 else if(!strcasecmp(data,"viewfile"))
 strcpy(data,"\n# viewfile <file name> [-query <variable number>] ;\nviewfile test.txt -query 100 ;\n");
 else if(!strcasecmp(data,"devstat"))
 strcpy(data,"\n# devstat <device> <variable number> ;\ndevstat eth0  100 ;\n");
 else if(!strcasecmp(data,"getenv"))   
 strcpy(data,"\n# getenv <word> <variable number> ;\ngetenv HOME 100 ;\n");
 else if(!strcasecmp(data,"query"))
 strcpy(data,"\n# query <variable number 1> <variable number 2>;\nquery 100 101 ;\n");
 else if(!strcasecmp(data,"choicebox"))
 strcpy(data,"\n# choicebox <variable number> <button 1> <button 2> ... | <label>\nchoicebox Yes No Quit | Are you sure ?\n");
 else if(!strcasecmp(data,"msgbox"))  
 strcpy(data,"\n# msgbox <variable number> ;\nset 100 Welcome !\nmsgbox 100 ;\n");
 else if(!strcasecmp(data,"draw"))
 strcpy(data,"\n# draw [INIT|SET|UNSET|PRINT|REFRESH|ASK|CLEAR|COLOR|BOX|BREFRESH|PRINTBOX|END] <args...> ;\ndraw INIT ;\ndraw PRINT 5 5 100\ndraw END ;\n");
 else if(!strcasecmp(data,"math"))
 strcpy(data,"\n# mathmath <variable number> [LOG|LN|E|SQRT] <number> ;\nmath SQRT 10 ;\n");
 else if(!strcasecmp(data,"encryptfile"))
 strcpy(data,"\n# encryptfile <variable number> ;\nset 100 file.name key ;\nencryptfile 100 ;\n"); 
 else if(!strcasecmp(data,"decryptfile"))
 strcpy(data,"\n# decryptfile <variable number>  ;\nset 100 file.name key ;\ndecryptfile 100 ;\n"); 
 else if(!strcasecmp(data,"firewall"))
 strcpy(data,"\n# firewall [add|rem] [allow|deny] <source ip> <destination ip> <port> <protocol> ;\nfirewall add deny ALL 192.168.1.2 ALL ICMP ;\n");
 else if(!strcasecmp(data,"binary-send"))
 strcpy(data,"\n# binary-send <variabel number> ;\nbinary-send 100 ;\n"); 
 else if(!strcasecmp(data,"binary-get"))
 strcpy(data,"\n# binary-get ;\nbinary-get ;\n");
 else if(!strcasecmp(data,""))
 strcpy(data,"\n#  ;\n ;\n");

 else strcpy(data,"\n# Command not in list. Try sscript -help <command>\n");
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, data, -1);
 return(TRUE);
}

int GTK_entry_ok(GtkWidget *widget, GtkWidget *entry)
{
 strcpy(queryGlVar,gtk_entry_get_text(GTK_ENTRY(entry_box)));
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_choice_box_1(GtkWidget *widget, GtkWidget *entry)
{
 strcpy(queryGlVar,"1");
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_choice_box_2(GtkWidget *widget, GtkWidget *entry)
{
 strcpy(queryGlVar,"2");
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_choice_box_3(GtkWidget *widget, GtkWidget *entry)
{
 strcpy(queryGlVar,"3");
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_choice_box_4(GtkWidget *widget, GtkWidget *entry)
{
 strcpy(queryGlVar,"4");
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_choice_box_5(GtkWidget *widget, GtkWidget *entry)
{
 strcpy(queryGlVar,"5");
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_choice_box_6(GtkWidget *widget, GtkWidget *entry)
{
 strcpy(queryGlVar,"6");
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_choice_box_7(GtkWidget *widget, GtkWidget *entry)
{
 strcpy(queryGlVar,"7");
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_choice_box_8(GtkWidget *widget, GtkWidget *entry)
{
 strcpy(queryGlVar,"8");
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_choice_box_9(GtkWidget *widget, GtkWidget *entry)
{
 strcpy(queryGlVar,"9");
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int GTK_choice_box_10(GtkWidget *widget, GtkWidget *entry)
{
 strcpy(queryGlVar,"10");
 gtk_widget_destroy(widget);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

void msgbox(char *type, char *string, int len)
{
 window = gtk_dialog_new ();
 if(strcasecmp(type,"header"))
  gtk_widget_set_usize (GTK_WIDGET (window), (strlen(string)*7)+100, 100);
 else
  gtk_widget_set_usize (GTK_WIDGET (window), strlen(string)+400, 100);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 label = gtk_label_new (string);
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
  label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area),
  button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window);
 gtk_main();
}

int textview(char *file, int argc, char *argv[])
{
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 600, 400);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);
 
 hbox = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);
  
 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);   
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (hbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);

 text = gtk_text_new (NULL, NULL);
 gtk_text_set_editable (GTK_TEXT (text), TRUE);
 gtk_text_set_word_wrap(GTK_TEXT (text), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
 gtk_widget_show (text);

 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text));
 gtk_widget_realize (text);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, " ", -1);
 gtk_text_thaw (GTK_TEXT (text));

 vbox2 = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
 gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 0);
 gtk_widget_show (vbox2);

 button = gtk_button_new_with_label ("Done");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_text_save), (gpointer) file);
 gtk_box_pack_start (GTK_BOX (vbox2), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);

 gtk_widget_show (window);
 gtk_main();
 return(0);
}

int viewfile(char *file, int argc, char *argv[])
{
 FILE *fpg;
 char line[255];

 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 600, 400);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);

 hbox = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (hbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);

 text = gtk_text_new (NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT (text), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
 gtk_widget_show (text);

 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text));
 gtk_widget_realize (text);
 fpg=fopen(file,"r");
 while(fgets(line,255,fpg)!=NULL)
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, line, -1);
 if(fpg!=NULL) fclose(fpg);
 gtk_text_thaw (GTK_TEXT (text));

 vbox2 = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
 gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 0);
 gtk_widget_show (vbox2);

 button = gtk_button_new_with_label ("Continue");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (vbox2), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window);
 gtk_main();
 return(0);
}

int gui_startup()
{
 int col=1;
 GtkWidget *b1, *b2, *b3, *b4, *b5, *t1;
 GdkColormap *cs;
 GdkColor sm;
 cs = gdk_colormap_get_system();
 extract_color(&sm, 250, 0, 50);
 if(!gdk_color_alloc(cs, &sm)) col=0;
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 380, 250);

 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);

 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);

 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);

 t1 = gtk_text_new (NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT (t1), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), t1, 0, 1, 0, 1);
 gtk_widget_show (t1);

 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (t1)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (t1));
 gtk_widget_realize (t1);
 if(col==1)
 gtk_text_insert (GTK_TEXT (t1), NULL, &sm, NULL, "*** Welcome to Socket Script ***", -1);
 else
 gtk_text_insert (GTK_TEXT (t1), NULL, &t1->style->black, NULL, "*** Welcome to Socket Script ***", -1);
 gtk_text_insert (GTK_TEXT (t1), NULL, &t1->style->black, NULL, "\n\nThis is the Socket Script startup screen.\nYou should start Socket Script with this syntax:\nsscript <script name>\n\nSee sscript -help for more.\n", -1);
 gtk_text_insert (GTK_TEXT (t1), NULL, &t1->style->black, NULL, "\nEnter a script to run, compose or debug.\nPress on the help button to learn more about Socket Script.\n", -1);

 label = gtk_label_new ("Script name:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 entry_box = gtk_entry_new();
 gtk_entry_set_text (GTK_ENTRY (entry_box), "sscript.file");
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 b1 = gtk_button_new_with_label ("Run");
 gtk_signal_connect_object (GTK_OBJECT (b1), "clicked",
  GTK_SIGNAL_FUNC(GTK_startup_run), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), b1, TRUE, TRUE, 0);  
 gtk_widget_show (b1);

 b2 = gtk_button_new_with_label ("Compose");
 gtk_signal_connect_object (GTK_OBJECT (b2), "clicked",
  GTK_SIGNAL_FUNC(GTK_startup_compose), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), b2, TRUE, TRUE, 0);
 gtk_widget_show (b2);

 b3 = gtk_button_new_with_label ("Debug");
 gtk_signal_connect_object (GTK_OBJECT (b3), "clicked",
  GTK_SIGNAL_FUNC(GTK_startup_debug), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), b3, TRUE, TRUE, 0);
 gtk_widget_show (b3);

 b4 = gtk_button_new_with_label ("Help");
 gtk_signal_connect_object (GTK_OBJECT (b4), "clicked",   
  GTK_SIGNAL_FUNC(GTK_startup_help), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), b4, TRUE, TRUE, 0);
 gtk_widget_show (b4);

 b5 = gtk_button_new_with_label ("Quit");
 gtk_signal_connect_object (GTK_OBJECT (b5), "clicked",
  GTK_SIGNAL_FUNC(GTK_startup_quit), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), b5, TRUE, TRUE, 0);
 gtk_widget_show (b5);

 gtk_widget_show (window);
 gtk_main();
 return(0);
}

int query(char *string)
{
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);  
 gtk_widget_show (vbox);

 hbox = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new (string);
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (hbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);

 vbox2 = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
 gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 0);
 gtk_widget_show (vbox2);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_entry_ok), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (vbox2), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window);
 gtk_main();
 return(0);
}

int view_n_query(char *file, char *string, int argc, char *argv[])
{
 FILE *fpg;
 char line[255];
 
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 600, 400);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 gtk_container_border_width (GTK_CONTAINER (window), 0);   
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);  
 
 hbox = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);
 
 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);      
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (hbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);
 
 text = gtk_text_new (NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT (text), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
 gtk_widget_show (text);

 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text));
 gtk_widget_realize (text);
 fpg=fopen(file,"r");
 while(fgets(line,255,fpg)!=NULL)  
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, line, -1);
 if(fpg!=NULL) fclose(fpg);
 gtk_text_thaw (GTK_TEXT (text));

 vbox2 = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
 gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 0);
 gtk_widget_show (vbox2);

 label = gtk_label_new (string);
 gtk_box_pack_start (GTK_BOX (vbox2), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox2), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);
 
 button = gtk_button_new_with_label ("Continue");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_entry_ok), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (vbox2), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window);
 gtk_main();
 return(0);
}

int choicebox(int argc1, char *argv1[])
{
 int i;
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);
 for(i=0;lindex(temp,i)!=NULL;i++)
 {
  if(!strcasecmp(lindex(temp,i),"|"))
  {
   label = gtk_label_new (lrange(temp,i+1));
   gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
   gtk_widget_show (label);
   break;
  }
 }
 hbox = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);
 i=0;
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
  choicebutton[i] = gtk_button_new_with_label (lindex(temp,i+2));
  gtk_signal_connect_object (GTK_OBJECT (choicebutton[i]), "clicked",
   GTK_SIGNAL_FUNC(GTK_choice_box_1), GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (hbox), choicebutton[i], TRUE, TRUE, 0);
  gtk_widget_show (choicebutton[i]);
  i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
  choicebutton[i] = gtk_button_new_with_label (lindex(temp,i+2));
  gtk_signal_connect_object (GTK_OBJECT (choicebutton[i]), "clicked",
   GTK_SIGNAL_FUNC(GTK_choice_box_2), GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (hbox), choicebutton[i], TRUE, TRUE, 0);
  gtk_widget_show (choicebutton[i]);
  i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
  choicebutton[i] = gtk_button_new_with_label (lindex(temp,i+2));
  gtk_signal_connect_object (GTK_OBJECT (choicebutton[i]), "clicked",
   GTK_SIGNAL_FUNC(GTK_choice_box_3), GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (hbox), choicebutton[i], TRUE, TRUE, 0);
  gtk_widget_show (choicebutton[i]);
  i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
  choicebutton[i] = gtk_button_new_with_label (lindex(temp,i+2));
  gtk_signal_connect_object (GTK_OBJECT (choicebutton[i]), "clicked",
   GTK_SIGNAL_FUNC(GTK_choice_box_4), GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (hbox), choicebutton[i], TRUE, TRUE, 0);
  gtk_widget_show (choicebutton[i]);
  i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
  choicebutton[i] = gtk_button_new_with_label (lindex(temp,i+2));
  gtk_signal_connect_object (GTK_OBJECT (choicebutton[i]), "clicked",
   GTK_SIGNAL_FUNC(GTK_choice_box_5), GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (hbox), choicebutton[i], TRUE, TRUE, 0);
  gtk_widget_show (choicebutton[i]);
  i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
  choicebutton[i] = gtk_button_new_with_label (lindex(temp,i+2));
  gtk_signal_connect_object (GTK_OBJECT (choicebutton[i]), "clicked",
   GTK_SIGNAL_FUNC(GTK_choice_box_6), GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (hbox), choicebutton[i], TRUE, TRUE, 0);
  gtk_widget_show (choicebutton[i]);
  i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
  choicebutton[i] = gtk_button_new_with_label (lindex(temp,i+2));
  gtk_signal_connect_object (GTK_OBJECT (choicebutton[i]), "clicked",
   GTK_SIGNAL_FUNC(GTK_choice_box_7), GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (hbox), choicebutton[i], TRUE, TRUE, 0);
  gtk_widget_show (choicebutton[i]);
  i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
  choicebutton[i] = gtk_button_new_with_label (lindex(temp,i+2));
  gtk_signal_connect_object (GTK_OBJECT (choicebutton[i]), "clicked",
   GTK_SIGNAL_FUNC(GTK_choice_box_8), GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (hbox), choicebutton[i], TRUE, TRUE, 0);
  gtk_widget_show (choicebutton[i]);
  i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
  choicebutton[i] = gtk_button_new_with_label (lindex(temp,i+2));
  gtk_signal_connect_object (GTK_OBJECT (choicebutton[i]), "clicked",
   GTK_SIGNAL_FUNC(GTK_choice_box_9), GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (hbox), choicebutton[i], TRUE, TRUE, 0);
  gtk_widget_show (choicebutton[i]);
  i++;
 }
 if(lindex(temp,i+2)!=NULL && *lindex(temp,i+2)!='|')
 {
  choicebutton[i] = gtk_button_new_with_label (lindex(temp,i+2));
  gtk_signal_connect_object (GTK_OBJECT (choicebutton[i]), "clicked",
   GTK_SIGNAL_FUNC(GTK_choice_box_10), GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (hbox), choicebutton[i], TRUE, TRUE, 0);
  gtk_widget_show (choicebutton[i]);
  i++;
 }
 gtk_widget_show (window);
 gtk_main();
 return(0);
}

int composer(char *file, int argc, char *argv[])
{
 GtkWidget *menuitem, *menu, *menubar, *menubutton;
 FILE *fpg;
 char line[255];  

 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 600, 400);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 sprintf(line,"Socket Script Composer - %s",file);
 gtk_window_set_title (GTK_WINDOW (window), line);
 strcpy(line,"");
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);

 menubar = gtk_menu_bar_new();
 gtk_box_pack_start (GTK_BOX (vbox), menubar, FALSE, TRUE, 0);
 gtk_widget_show (menubar);

 /* file */
 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Clear text");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_clear), NULL);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Save file");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_save), (gpointer) file);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Quit");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_quit), GTK_OBJECT(window));
 gtk_widget_show(menuitem);

 menubutton = gtk_menu_item_new_with_label("File");
 gtk_widget_show(menubutton);

 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 /* header */
 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Server");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "server");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Port");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "port");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Debug");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "debug");
 gtk_widget_show(menuitem);  

 menuitem = gtk_menu_item_new_with_label("Chop");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "chop");
 gtk_widget_show(menuitem);  

 menuitem = gtk_menu_item_new_with_label("Virtual");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "virtual");
 gtk_widget_show(menuitem);  

 menubutton = gtk_menu_item_new_with_label("Header");
 gtk_widget_show(menubutton);

 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 /* Version */
 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Version");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "version");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Require");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "require");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Require GUI");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "require-gui");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Include");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "include");
 gtk_widget_show(menuitem);

 menubutton = gtk_menu_item_new_with_label("Version");
 gtk_widget_show(menubutton);
 
 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 /* networking */
 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Read");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "read");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Write");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "write");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Ping");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "ping");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Test");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "test");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Dump");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "dump");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Rconnect");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "rconnect");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Rread");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "rread");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Rwrite");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "rwrite");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Rdisconnect");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "rdisconnect");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("UDP send");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "udpsend");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("UDP listen");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "udplisten");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Raw");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "raw");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("ICMP listen");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "icmplisten");  
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Binary send");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "binary-send");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Binary get");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "binary-get");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Firewall");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "firewall");
 gtk_widget_show(menuitem);

 menubutton = gtk_menu_item_new_with_label("Networking");
 gtk_widget_show(menubutton);
 
 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton),menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 /* I/O */
 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Print");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "print");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Ask");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "ask");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Save");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "save");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Append");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "append");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Remove");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "remove");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("RemEntry");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "rementry");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Save All");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "saveall");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("File");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "file");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Add Log");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "addlog");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Enrypt file");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "encryptfile");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Decrypt file");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "decryptfile");
 gtk_widget_show(menuitem);

 menubutton = gtk_menu_item_new_with_label("I/O");
 gtk_widget_show(menubutton);
 
 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 /* Parse */
 menu = gtk_menu_new();
 
 menuitem = gtk_menu_item_new_with_label("Parse");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "parse");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Set");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "set");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("If match");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "ifmatch");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("If word");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "ifword");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("If word 2");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "ifword2");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("If master");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "ifmaster");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("If master 2");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "ifmaster2");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("?compare");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "?compare");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("?match");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "?match");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("If");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "if");
 gtk_widget_show(menuitem);
 
 menubutton = gtk_menu_item_new_with_label("Parse");
 gtk_widget_show(menubutton);

 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 /* Loops */
 menu = gtk_menu_new();
 
 menuitem = gtk_menu_item_new_with_label("For");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "for");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("End For");   
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "endfor");   
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Loop");   
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "loop");   
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Go To");   
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "goto");   
 gtk_widget_show(menuitem);
 
 menubutton = gtk_menu_item_new_with_label("Loops");
 gtk_widget_show(menubutton);

 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 /* GUI */
 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Msg Box");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "msgbox");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Query");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "query");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Choice Box");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "choicebox");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("View File");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "viewfile");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Draw");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "draw");
 gtk_widget_show(menuitem);

 menubutton = gtk_menu_item_new_with_label("GUI");
 gtk_widget_show(menubutton);

 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 /* Settings */
 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Set master");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "setmaster");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Set LOG file");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "setlogfile");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Set Windows compatibility");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "setwindows");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Set signals off");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "setsignalsoff");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Set remote echo");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "setremoteecho");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Set user@host");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "setuserhost");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Set as service");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "setservice");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Set reverse chop");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "setreversechop");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Set strict-check");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "setstrictcheck");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Set strict-write");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "setstrictwrite");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Set trace");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "settrace");
 gtk_widget_show(menuitem);

 menubutton = gtk_menu_item_new_with_label("Settings");
 gtk_widget_show(menubutton);

 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton),menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 /* Misc */
 menu = gtk_menu_new();
 
 menuitem = gtk_menu_item_new_with_label("Resolve");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "resolve");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Cron");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "cron");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Random");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "random");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Dev stats");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "devstats");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Run");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "run");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Get env");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "getenv");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Background");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "background");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Command");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "command");
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Math");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_add), (gpointer) "math");
 gtk_widget_show(menuitem);

 menubutton = gtk_menu_item_new_with_label("Misc");
 gtk_widget_show(menubutton);

 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 /* Help */

 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Getting started");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_help), NULL);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Command description");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_cmd), NULL);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Libraries");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_lib), NULL);
 gtk_widget_show(menuitem);
 
 menuitem = gtk_menu_item_new_with_label("About");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(GTK_composer_about), NULL);
 gtk_widget_show(menuitem);

 menubutton = gtk_menu_item_new_with_label("Help");
 gtk_widget_show(menubutton);
  
 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 /* end menus */

 hbox = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);
  
 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);   
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (hbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);

 text = gtk_text_new (NULL, NULL);
 gtk_text_set_editable (GTK_TEXT (text), TRUE);
 gtk_text_set_word_wrap(GTK_TEXT (text), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
 gtk_widget_show (text);

 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text));
 gtk_widget_realize (text);
 fpg=fopen(file,"r");
 while(fgets(line,255,fpg)!=NULL)  
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, line, -1);
 if(fpg!=NULL) fclose(fpg);
 gtk_text_thaw (GTK_TEXT (text));
 gtk_widget_show (window);
 gtk_main();
 return(0);
}

int gui_help(char *string, int argc, char *argv[])
{
 GdkColormap *cmap;
 GdkColor red, ed;
#ifdef GTK_HELP_COLORS
 int success=1;
#else
 int success=0;
#endif
 cmap = gdk_colormap_get_system();
 extract_color(&red, 255, 0, 0);
 if(!gdk_color_alloc(cmap, &red)) success=0;
 extract_color(&ed, 0, 0, 255);
 if(!gdk_color_alloc(cmap, &ed)) success=0;
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (window), 600, 400);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
 gtk_window_set_title (GTK_WINDOW (window), "Socket Script");
 gtk_container_border_width (GTK_CONTAINER (window), 0);
 
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window), vbox);
 gtk_widget_show (vbox);
 
 hbox = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 10);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);   
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (hbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);

 text = gtk_text_new (NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT (text), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
 gtk_widget_show (text);

 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text));
 gtk_widget_realize (text);
 if(success)
 {
 gtk_text_insert (GTK_TEXT (text), NULL, &red, NULL, "This is the online help screen for Socket Script.\n", -1);
 if(!strcasecmp(lindex(string,0),"Socket") && !strcasecmp(lindex(string,1),"Script"))
 {
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, "Syntax:\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &ed, NULL, "        sscript [-d] [-c] [-r <remote ip> <port>] [script or project file [-l line]] [-help [command]] [-display <screen>]\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &ed, NULL, "\nsscript", -1); 
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, " loads the startup screen and starts sscript.file\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &ed, NULL, "sscript <script file or project file>", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, " loads the specified script or project\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &ed, NULL, "sscript <script file> -l <line>", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, " will load the script <script file> and start running it at line number <line>\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &ed, NULL, "sscript -help [command]", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, " gets you online help on the specified command. Use sscript -help index for a list of all commands.\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &ed, NULL, "sscript -d <script>", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, " will launch the debugger to check the specified script for possible errors.\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &ed, NULL, "sscript -c <script>", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, " will launch the composer which allows you to make your scripts.\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &ed, NULL, "sscript -r <server ip> <server port> <script>", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, " will fetch <script> from a remote server running the ERSS script (examples/sscript.script-serving)  \n\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, "The full documentation is also available in docs/sscript.doc (or sscript -help docs) along with technical notes on how to make your scripts.\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, "You can also look at the examples in the examples dir that came with this package.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, "Socket Script is free software.\n(C) 1998 Patrick Lambert <drow@fastethernet.net>\nLatest version available at http://devplanet.fastethernet.net/sscript.html\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, "or ftp://sunsite.unc.edu/pub/Linux/devel/\n", -1);
 }
 else
 {
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, string, -1);
 }
 }
 else
 {
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, "This is the online help screen for Socket Script.\n", -1);
 gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, string, -1);
 }
 gtk_text_thaw (GTK_TEXT (text));

 vbox2 = gtk_vbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
 gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 0);
 gtk_widget_show (vbox2);

 hscrollbar = gtk_hscrollbar_new (GTK_TEXT (text)->hadj);
 gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
  GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);
 gtk_widget_show (hscrollbar);

 button = gtk_button_new_with_label ("Quit");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(GTK_destroy_widget), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (vbox2), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window);
 gtk_main();
 return(0);
}

int custom_callbacks(gint choice, GtkWidget *entry)
{
 FILE *fpg;
 if(text!=NULL)
 {
  fpg=fopen(lindex(global_var,1),"w");
  fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0,
   gtk_text_get_length(GTK_TEXT(text))),fpg);
  if(fpg!=NULL) fclose(fpg);
 }
 if(entry_box!=NULL)
 {
  sprintf(queryGlVar,"%d %s %s",choice,lindex(global_var,0),gtk_entry_get_text(GTK_ENTRY(entry_box)));
 }
 else
 {
  sprintf(queryGlVar,"%d %s ;",choice,lindex(global_var,0));
 }
 gtk_widget_destroy(window);
 gtk_main_quit();
 gdk_flush();
 return(FALSE);
}

int custom_gui(char in[1024][512])
{
 GdkColormap *cmap;
 GdkColor red, ed;
 GtkWidget *separator;
 if(!strcasecmp(lindex(temp,1),"main"))
 {
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
   GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
   GTK_SIGNAL_FUNC(GTK_destroy_widget), &window);
  gtk_window_set_title (GTK_WINDOW (window), lrange(temp,2));
  gtk_container_border_width (GTK_CONTAINER (window), 2);
  gtk_widget_realize(window);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_widget_show (vbox);

  text = NULL;
  entry_box = NULL;
 }
 if(!strcasecmp(lindex(temp,1),"hbox"))
 {
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);
 }
 if(!strcasecmp(lindex(temp,1),"size"))
 {
  gtk_widget_set_usize (GTK_WIDGET (window), atoi(lindex(temp,2)), atoi(lindex(temp,3)));
 }
 if(!strcasecmp(lindex(temp,1),"textbox"))
 {
  table = gtk_table_new (2, 2, FALSE);
  gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
  gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
  if(!strcasecmp(lindex(temp,2),"horizontal"))
   gtk_box_pack_start (GTK_BOX (hbox), table, TRUE, TRUE, 0);
  if(!strcasecmp(lindex(temp,2),"vertical"))
   gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
  gtk_widget_show (table);
 
  text = gtk_text_new (NULL, NULL);
  gtk_text_set_word_wrap(GTK_TEXT (text), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
  gtk_widget_show (text);
  
  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
   GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_widget_show (vscrollbar);
  gtk_text_freeze (GTK_TEXT (text));
  gtk_widget_realize (text);
  gtk_text_set_word_wrap(GTK_TEXT (text), TRUE);
  gtk_text_thaw (GTK_TEXT (text));
 }
 if(!strcasecmp(lindex(temp,1),"text-editable"))
 {
  gtk_text_set_editable(GTK_TEXT (text), TRUE);
 }
 if(!strcasecmp(lindex(temp,1),"button"))
 {
  button = gtk_button_new_with_label (lrange(temp,4));
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
   GTK_SIGNAL_FUNC(custom_callbacks), (gpointer) atoi(lindex(temp,3)));
  if(!strcasecmp(lindex(temp,2),"horizontal"))
   gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
  if(!strcasecmp(lindex(temp,2),"vertical"))
   gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
  gtk_widget_show (button);
 }
 if(!strcasecmp(lindex(temp,1),"yesno"))
 {
  button = gtk_button_new_with_label ("Yes");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
   GTK_SIGNAL_FUNC(custom_callbacks), (gpointer) 0);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);
  button = gtk_button_new_with_label ("No");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
   GTK_SIGNAL_FUNC(custom_callbacks), (gpointer) 1);  
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
  gtk_widget_show (button);
 }
 if(!strcasecmp(lindex(temp,1),"entry"))
 {
  entry_box = gtk_entry_new();
  gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
  if(!strcasecmp(lindex(temp,2),"horizontal"))
   gtk_box_pack_start (GTK_BOX (hbox), entry_box, TRUE, TRUE, 0);
  if(!strcasecmp(lindex(temp,2),"vertical"))
   gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
  gtk_widget_show (entry_box);
 }
 if(!strcasecmp(lindex(temp,1),"insert"))
 {
  if(!strcasecmp(lindex(temp,2),"EOL"))
  gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, "\n", -1);
  else
  gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, in[atoi(lindex(temp,2))], -1);
 }
 if(!strcasecmp(lindex(temp,1),"insert-red"))
 {
  extract_color(&red, 255, 0, 0);
  gdk_color_alloc(cmap, &red);
  gtk_text_insert (GTK_TEXT (text), NULL, &red, NULL, in[atoi(lindex(temp,2))], -1);
 }
 if(!strcasecmp(lindex(temp,1),"insert-blue"))
 {
  extract_color(&ed, 0, 0, 255);
  gdk_color_alloc(cmap, &ed);
  gtk_text_insert (GTK_TEXT (text), NULL, &ed, NULL, in[atoi(lindex(temp,2))], -1);
 }
 if(!strcasecmp(lindex(temp,1),"toolbar"))
 {
  hbox = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);
 }
 if(!strcasecmp(lindex(temp,1),"label"))
 {
  label = gtk_label_new (lrange(temp,3));
  if(!strcasecmp(lindex(temp,2),"horizontal"))
   gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
  if(!strcasecmp(lindex(temp,2),"vertical"))
   gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
  gtk_widget_show (label);
 }
 if(!strcasecmp(lindex(temp,1),"separator"))
 {
  separator = gtk_hseparator_new();
  gtk_box_pack_start (GTK_BOX (vbox), separator, TRUE, TRUE, 0);
  gtk_widget_show (separator);
 }
 if(!strcasecmp(lindex(temp,1),"position"))
 {
  gtk_widget_set_uposition (window, atoi(lindex(temp,2)), atoi(lindex(temp,3)));
 }
 if(!strcasecmp(lindex(temp,1),"icon"))
 {
  button = gtk_button_new ();
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
   GTK_SIGNAL_FUNC(custom_callbacks), (gpointer) atoi(lindex(temp,3)));
  if(!strcasecmp(lindex(temp,2),"horizontal"))
   gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
  if(!strcasecmp(lindex(temp,2),"vertical"))
   gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
  gtk_widget_show (button);   

  style = gtk_widget_get_style(button);

  pixmap = gdk_pixmap_create_from_xpm (window->window, &mask,
   &style->bg[GTK_STATE_NORMAL], lindex(temp,4));
  pixmapwid = gtk_pixmap_new (pixmap, mask);

  box3 = gtk_hbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (box3), 2);
  gtk_container_add (GTK_CONTAINER (box3), pixmapwid);
  gtk_container_add (GTK_CONTAINER (button), box3);
  gtk_widget_show (pixmapwid);
  gtk_widget_show (box3);
 }
 if(!strcasecmp(lindex(temp,1),"show"))
 {
  sprintf(global_var,"%s %s ;",lindex(temp,2),lindex(temp,3));
  gtk_widget_show (window);  
  gtk_main();
  return(0);  
 }
 return(0);
}
#endif /* gtk */
#endif /* gui */
