# remove duplicated files when reading applypatch input
# 
# To apply this patch:
# STEP 1: Chdir to the source directory.
# STEP 2: Run the 'applypatch' program with this patch file as input.
#
# If you do not have 'applypatch', it is part of the 'makepatch' package
# that you can fetch from the Comprehensive Perl Archive Network:
# http://www.perl.com/CPAN/authors/Johan_Vromans/makepatch-x.y.tar.gz
# In the above URL, 'x' should be 2 or higher.
#
# To apply this patch without the use of 'applypatch':
# STEP 1: Chdir to the source directory.
# STEP 2: Run the 'patch' program with this file as input.
#
#### End of Preamble ####

#### Patch data follows ####
diff -c 'diffstat-1.31/diffstat.c' 'diffstat-1.31_applypatch/diffstat.c'
Index: ./diffstat.c
Prereq:  1.31 
*** ./diffstat.c	Tue Aug 20 19:38:52 2002
--- ./diffstat.c	Sat Nov  9 22:54:12 2002
***************
*** 483,489 ****
  	    if (match(buffer, "Index: ")) {
  		s = strrchr(buffer, BLANK);	/* last token is name */
  		blip('.');
! 		that = new_data(s + 1);
  		ok = begin_data(that);
  	    }
  	    break;
--- 483,491 ----
  	    if (match(buffer, "Index: ")) {
  		s = strrchr(buffer, BLANK);	/* last token is name */
  		blip('.');
! 		if (strlen(that->name) != 0)
! 		   s = do_merging(that, s + 1);
! 		that = new_data(s);
  		ok = begin_data(that);
  	    }
  	    break;
***************
*** 493,499 ****
  		&& *(s = skip_options(buffer + 5)) != '\0') {
  		s = strrchr(buffer, BLANK);
  		blip('.');
! 		that = new_data(s + 1);
  		ok = begin_data(that);
  	    }
  	    break;
--- 495,503 ----
  		&& *(s = skip_options(buffer + 5)) != '\0') {
  		s = strrchr(buffer, BLANK);
  		blip('.');
! 		if (strlen(that->name) != 0)
! 		   s = do_merging(that, s + 1);
! 		that = new_data(s);
  		ok = begin_data(that);
  	    }
  	    break;
#### End of Patch data ####

#### ApplyPatch data follows ####
# Data version        : 1.0
# Date generated      : Sat Nov  9 22:55:16 2002
# Generated by        : makepatch 2.00_05
# Recurse directories : Yes
# p 'diffstat.c' 21017 1036900452 0100644
#### End of ApplyPatch data ####

#### End of Patch kit [created: Sat Nov  9 22:55:16 2002] ####
#### Patch checksum: 55 1528 36697 ####
#### Checksum: 73 2205 27936 ####
