#!/usr/bin/env python

"""
pyupdatesd: A simple yum update checker.

This script will watch for available yum updates and show a Gtk2 tray icon and
notification pop-up when updates become available.

This is intended for desktop environments like XFCE that don't have a native
PackageKit update watcher.

Set this script to run on session startup, and it will check for updates every
15 minutes (by default; this is configurable in the source code).

This software is open domain and may be freely modified and distributed.

Requires: pygtk2

--Kirsle
http://sh.kirsle.net
"""

################################################################################
# Configuration Section Begins Here                                            #
################################################################################

c = dict(
    # The title to be shown on the pop-up and the icon tooltip.
    title = "Updates Available",

    # The message to be shown in the pop-up.
    message = "There are updates available to install.",

    # Icon to use in the system tray and pop-up.
    icon = "/usr/share/icons/PointLinux-Faenza/apps/48/update-notifier.png",

    # Frequency to check for available updates.
    interval = 900, # 15 minutes

    # Command to run to check for available updates, and the expected status
    # code that indicates updates are available.
    check = "/usr/bin/apt-get -s dist-upgrade | /bin/grep -c '^Inst '",

    # Path to notify-send (set to None if you don't want notifications)
    notify = "/usr/bin/notify-send",

    # Command to run for your graphical updater (i.e. yumex, gpk-update-viewer)
    gui = "/usr/bin/gksu '/usr/sbin/synaptic --dist-upgrade-mode true --non-interactive'",
)

################################################################################
# Configuration Section Ends Here                                              #
################################################################################

import gtk
import gobject

import commands
import subprocess
from time import time

# Do not run in a LiveCD session
import os.path
import sys
if os.path.exists('/etc/pointlinux-installer/install.conf'):
    print "Can't run in a LiveCD session!"
    sys.exit()

def do_updates():
    """Show your graphical update manager."""
    subprocess.call(c['gui'], shell=True)

def onClick(widget):
    """Event handler for the tray icon being clicked."""
    widget.set_visible(False)
    gobject.timeout_add(1, do_updates)

def show_notify():
    subprocess.call([c['notify'],
        '-a', __name__,
        '-i', c['icon'],
        c['title'],
        c['message'],
    ])

tray = gtk.StatusIcon()
tray.set_from_file(c['icon'])
tray.set_title(c['title'])
tray.set_tooltip(c['title'])
tray.set_visible(False)
tray.connect('activate', onClick)

next_check = int(time()) + c['interval']
def main_loop():
    # Time to check?
    global next_check
    if int(time()) >= next_check:
        status = commands.getoutput(c['check'])

        # Updates?
        if status != "0":
            tray.set_visible(True)
            show_notify()
        elif tray.get_visible() == True and status == "0":
            # Updates have disappeared behind our back!
            tray.set_visible(False)

        next_check = int(time()) + c['interval']

    gobject.timeout_add(1000, main_loop)

gobject.timeout_add(1000, main_loop)

gtk.main()

# vim:expandtab