// -*- C++ -*- header wrapper.

// Copyright (C) 1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

//
// ISO C++ draft working paper: 18.2.2  Implementation properties: C library
//

#ifndef _CPP_CLOCALE
#define _CPP_CLOCALE     1

# include <bits/std_cstddef.h> /* pick up NULL */

  namespace _C_Swamp {
    extern "C" {
#     define _IN_C_SWAMP_
#     include_next <locale.h>
    }

    typedef struct lconv _CPP_lconv_capture;
    const int _CPP_LC_ALL_capture = LC_ALL;
    const int _CPP_LC_COLLATE_capture = LC_COLLATE;
    const int _CPP_LC_CTYPE_capture = LC_CTYPE;
    const int _CPP_LC_MONETARY_capture = LC_MONETARY;
    const int _CPP_LC_NUMERIC_capture = LC_NUMERIC;
    const int _CPP_LC_TIME_capture = LC_TIME;
#if 0 /* XXX need proper macro guard for this common extension. */
    const int _CPP_LC_MESSAGES_capture = LC_MESSAGES;
#endif

    namespace _C_Shadow { }
  } // close namespace ::_C_Swamp::

// #  undef  NULL
// #  define NULL 0  /* handled in <cstddef> */
#  undef LC_ALL
#  define LC_ALL	::_C_Swamp::_CPP_LC_ALL_capture
#  undef LC_COLLATE
#  define LC_COLLATE	::_C_Swamp::_CPP_LC_COLLATE_capture
#  undef LC_CTYPE
#  define LC_CTYPE	::_C_Swamp::_CPP_LC_CTYPE_capture
#  undef LC_MONETARY
#  define LC_MONETARY	::_C_Swamp::_CPP_LC_MONETARY_capture
#  undef LC_NUMERIC
#  define LC_NUMERIC	::_C_Swamp::_CPP_LC_NUMERIC_capture
#  undef LC_TIME
#  define LC_TIME	::_C_Swamp::_CPP_LC_TIME_capture
#if 0 /* XXX need proper macro guard for this common extension. */
#  undef LC_MESSAGES
#  define LC_MESSAGES	::_C_Swamp::_CPP_LC_MESSAGES_capture
#endif

#  undef lconv
#  undef setlocale
#  undef localeconv

  namespace _C_Swamp {
    namespace _C_Shadow {
    }
  }
  namespace std {

    // Adopt C names into std::
    using ::_C_Swamp::setlocale;  

    // note: still a POD type:
    struct lconv  : ::_C_Swamp::_CPP_lconv_capture  { };

    inline lconv* localeconv() 
      { return reinterpret_cast<lconv*>(::_C_Swamp::localeconv()); }

  } // close namespace std::
  
  namespace _C_Swamp {
    namespace _C_Shadow {
      using ::std::lconv;
      using ::std::localeconv;
    }
  }

# undef _IN_C_SWAMP_

#endif /* _CPP_CLOCALE */
