/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;

public class Execute {
    public static final int INVALID = Integer.MAX_VALUE;
    private String[] cmdl = null;
    private String[] env = null;
    private int exitValue = Integer.MAX_VALUE;
    private ExecuteStreamHandler streamHandler;
    private ExecuteWatchdog watchdog;
    private File workingDirectory = null;
    private Project project = null;
    private boolean newEnvironment = false;
    private boolean useVMLauncher = true;
    private static String antWorkingDirectory = System.getProperty("user.dir");
    private static CommandLauncher vmLauncher = null;
    private static CommandLauncher shellLauncher = null;
    private static Vector procEnvironment = null;

    public static synchronized Vector getProcEnvironment() {
        if (procEnvironment != null) {
            return procEnvironment;
        }
        procEnvironment = new Vector();
        try {
            String string;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Execute execute = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)byteArrayOutputStream));
            execute.setCommandline(Execute.getProcEnvCommand());
            execute.setNewenvironment(true);
            int n = execute.execute();
            if (n != 0) {
                // empty if block
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader(byteArrayOutputStream.toString()));
            String string2 = null;
            String string3 = System.getProperty("line.separator");
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf(61) == -1) {
                    if (string2 == null) {
                        string2 = string3 + string;
                        continue;
                    }
                    string2 = string2 + string3 + string;
                    continue;
                }
                if (string2 != null) {
                    procEnvironment.addElement(string2);
                }
                string2 = string;
            }
            procEnvironment.addElement(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return procEnvironment;
    }

    private static String[] getProcEnvCommand() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("mac os") >= 0) {
            String string2;
            try {
                string2 = System.getProperty("os.version");
                int n = Integer.parseInt(string2.substring(0, string2.indexOf(46)));
                if (n >= 10) {
                    String[] stringArray = new String[]{"/usr/bin/env"};
                    return stringArray;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string2 = null;
            return string2;
        }
        if (string.indexOf("os/2") >= 0) {
            String[] stringArray = new String[]{"cmd", "/c", "set"};
            return stringArray;
        }
        if (string.indexOf("indows") >= 0) {
            if (string.indexOf("nt") >= 0 || string.indexOf("2000") >= 0) {
                String[] stringArray = new String[]{"cmd", "/c", "set"};
                return stringArray;
            }
            String[] stringArray = new String[]{"command.com", "/c", "set"};
            return stringArray;
        }
        String[] stringArray = new String[]{"/usr/bin/env"};
        return stringArray;
    }

    public Execute() {
        this((ExecuteStreamHandler)new PumpStreamHandler(), null);
    }

    public Execute(ExecuteStreamHandler executeStreamHandler) {
        this(executeStreamHandler, null);
    }

    public Execute(ExecuteStreamHandler executeStreamHandler, ExecuteWatchdog executeWatchdog) {
        this.streamHandler = executeStreamHandler;
        this.watchdog = executeWatchdog;
    }

    public String[] getCommandline() {
        return this.cmdl;
    }

    public void setCommandline(String[] stringArray) {
        this.cmdl = stringArray;
    }

    public void setNewenvironment(boolean bl) {
        this.newEnvironment = bl;
    }

    public String[] getEnvironment() {
        if (this.env == null || this.newEnvironment) {
            return this.env;
        }
        return this.patchEnvironment();
    }

    public void setEnvironment(String[] stringArray) {
        this.env = stringArray;
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file == null || file.getAbsolutePath().equals(antWorkingDirectory) ? null : file;
    }

    public void setAntRun(Project project) throws BuildException {
        this.project = project;
    }

    public void setVMLauncher(boolean bl) {
        this.useVMLauncher = bl;
    }

    public int execute() throws IOException {
        CommandLauncher commandLauncher;
        CommandLauncher commandLauncher2 = commandLauncher = vmLauncher != null ? vmLauncher : shellLauncher;
        if (!this.useVMLauncher) {
            commandLauncher = shellLauncher;
        }
        Process process = commandLauncher.exec(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory);
        try {
            this.streamHandler.setProcessInputStream(process.getOutputStream());
            this.streamHandler.setProcessOutputStream(process.getInputStream());
            this.streamHandler.setProcessErrorStream(process.getErrorStream());
        }
        catch (IOException iOException) {
            process.destroy();
            throw iOException;
        }
        this.streamHandler.start();
        if (this.watchdog != null) {
            this.watchdog.start(process);
        }
        this.waitFor(process);
        if (this.watchdog != null) {
            this.watchdog.stop();
        }
        this.streamHandler.stop();
        if (this.watchdog != null) {
            this.watchdog.checkException();
        }
        return this.getExitValue();
    }

    protected void waitFor(Process process) {
        try {
            process.waitFor();
            this.setExitValue(process.exitValue());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void setExitValue(int n) {
        this.exitValue = n;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    private String[] patchEnvironment() {
        Vector vector = (Vector)Execute.getProcEnvironment().clone();
        int n = 0;
        while (n < this.env.length) {
            int n2 = this.env[n].indexOf(61);
            String string = this.env[n].substring(0, n2 + 1);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                if (((String)vector.elementAt(n4)).startsWith(string)) {
                    vector.removeElementAt(n4);
                    break;
                }
                ++n4;
            }
            vector.addElement(this.env[n]);
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void runCommand(Task task, String[] stringArray) throws BuildException {
        try {
            task.log(Commandline.toString(stringArray), 3);
            Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler(task, 2, 0));
            execute.setAntRun(task.getProject());
            execute.setCommandline(stringArray);
            int n = execute.execute();
            if (n != 0) {
                throw new BuildException(stringArray[0] + " failed with return code " + n, task.getLocation());
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Could not launch " + stringArray[0] + ": " + iOException, task.getLocation());
        }
    }

    static /* synthetic */ String access$200() {
        return antWorkingDirectory;
    }

    static {
        try {
            vmLauncher = new Java13CommandLauncher();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("mac os") >= 0) {
            shellLauncher = new MacCommandLauncher(new CommandLauncher(null));
        } else if (string.indexOf("os/2") >= 0) {
            shellLauncher = new WinNTCommandLauncher(new CommandLauncher(null));
        } else if (string.indexOf("windows") >= 0) {
            Object object = System.getProperty("java.version").startsWith("1.1") ? new Java11CommandLauncher(null) : new CommandLauncher(null);
            shellLauncher = string.indexOf("nt") >= 0 || string.indexOf("2000") >= 0 ? new WinNTCommandLauncher((CommandLauncher)object) : new ScriptCommandLauncher("bin/antRun.bat", (CommandLauncher)object);
        } else {
            shellLauncher = new ScriptCommandLauncher("bin/antRun", new CommandLauncher(null));
        }
    }
}

