/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.antlr.CommonASTWithHiddenTokens;
import de.hunsicker.antlr.CommonHiddenStreamToken;
import de.hunsicker.antlr.Token;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.ExtendedToken;

public class Node
extends CommonASTWithHiddenTokens
implements Comparable {
    protected String text;
    protected int endColumn;
    protected int endLine;
    protected int startColumn;
    protected int startLine;
    protected int type;

    public Node() {
    }

    public Node(int type, String text, int startLine, int startColumn, int endLine, int endColumn) {
        this.type = type;
        this.text = text;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public Node(int startLine, int startColumn, int endLine, int endColumn) {
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public Node(int type, String text) {
        this.type = type;
        this.text = text;
    }

    public Node(Token tok) {
        this.initialize(tok);
    }

    public Node(String text) {
        this.text = text;
    }

    public void setEndColumn(int column) {
        this.endColumn = column;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndLine(int line) {
        this.endLine = line;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setHiddenAfter(CommonHiddenStreamToken token) {
        this.hiddenAfter = token;
    }

    public void setHiddenBefore(CommonHiddenStreamToken token) {
        this.hiddenBefore = token;
    }

    public boolean isPositionKnown() {
        return this.startLine + this.endLine > 0;
    }

    public void setStartColumn(int column) {
        this.startColumn = column;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartLine(int line) {
        this.startLine = line;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o == null) {
            throw new NullPointerException("o == null");
        }
        if (!(o instanceof Node)) {
            throw new ClassCastException(o.getClass() + " not of type de.hunsicker.jalopy.language.Node");
        }
        Node other = (Node)o;
        if (this.startsBefore(other)) {
            return -1;
        }
        if (this.endsAfter(other)) {
            return 1;
        }
        return 0;
    }

    public boolean contains(Node node) {
        return this.contains(node.startLine, node.startColumn) && this.contains(node.endLine, node.endColumn);
    }

    public boolean contains(int startLine, int startColumn, int endLine, int endColumn) {
        return this.contains(startLine, startColumn) && this.contains(endLine, endColumn);
    }

    public boolean contains(int line, int column) {
        boolean afterStart = false;
        boolean beforeEnd = false;
        if (this.startLine < line) {
            afterStart = true;
        } else if (this.startLine == line && this.startColumn <= column) {
            afterStart = true;
        }
        if (this.endLine > line) {
            beforeEnd = true;
        } else if (this.endLine == line && this.endColumn >= column) {
            beforeEnd = true;
        }
        return afterStart && beforeEnd;
    }

    public boolean endsAfter(Node other) {
        boolean result = false;
        if (this.endLine > other.endLine) {
            result = true;
        } else if (this.endLine == other.endLine && this.endColumn >= other.endColumn) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        return this.text.hashCode() + this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Node) {
            Node node = (Node)o;
            return this.text.equals(node.text) && this.type == node.type;
        }
        return false;
    }

    public void initialize(AST node) {
        Node n = (Node)node;
        this.text = n.text;
        this.type = n.getType();
        this.startLine = n.startLine;
        this.endLine = n.endLine;
        this.startColumn = n.startColumn;
        this.endColumn = n.endColumn;
        this.hiddenBefore = n.getHiddenBefore();
        this.hiddenAfter = n.getHiddenAfter();
    }

    public void initialize(int type, String text) {
        this.type = type;
        this.text = text;
    }

    public void initialize(Token tok) {
        ExtendedToken token = (ExtendedToken)tok;
        this.text = token.text;
        this.type = token.getType();
        this.startLine = token.getLine();
        this.endLine = token.endLine;
        this.startColumn = token.getColumn();
        this.endColumn = token.endColumn;
        this.hiddenBefore = token.getHiddenBefore();
        this.hiddenAfter = token.getHiddenAfter();
    }

    public boolean startsBefore(Node other) {
        boolean result = false;
        if (this.startLine < other.startLine) {
            result = true;
        } else if (this.startLine == other.startLine && this.startColumn <= other.startColumn) {
            result = true;
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(50);
        buf.append(this.text);
        buf.append(' ');
        buf.append(this.startLine);
        buf.append(':');
        buf.append(this.startColumn);
        buf.append(' ');
        buf.append(this.endLine);
        buf.append(':');
        buf.append(this.endColumn);
        return buf.toString();
    }
}

