/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.filter;

import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.filter.Filter;

public class ContentFilter
implements Filter {
    private static final String CVS_ID = "@(#) $RCSfile: ContentFilter.java,v $ $Revision: 1.1 $ $Date: 2002/03/12 07:00:50 $ $Name: jdom_1_0_b8 $";
    public static final int ELEMENT = 1;
    public static final int CDATA = 2;
    public static final int TEXT = 4;
    public static final int COMMENT = 8;
    public static final int PI = 16;
    public static final int ENTITYREF = 32;
    public static final int DOCUMENT = 64;
    protected int filterMask;

    public ContentFilter() {
        this.setDefaultMask();
    }

    public ContentFilter(int n) {
        this.setFilterMask(n);
    }

    public ContentFilter(boolean bl) {
        if (bl) {
            this.setDefaultMask();
        } else {
            this.filterMask &= ~this.filterMask;
        }
    }

    public boolean canAdd(Object object) {
        return this.matches(object);
    }

    public boolean canRemove(Object object) {
        return this.matches(object);
    }

    public boolean equals(Object object) {
        if (object instanceof ContentFilter) {
            ContentFilter contentFilter = (ContentFilter)object;
            return this.filterMask == contentFilter.filterMask;
        }
        return false;
    }

    public int getFilterMask() {
        return this.filterMask;
    }

    public boolean matches(Object object) {
        if (object instanceof Element) {
            return (this.filterMask & 1) != 0;
        }
        if (object instanceof CDATA) {
            return (this.filterMask & 2) != 0;
        }
        if (object instanceof Text) {
            return (this.filterMask & 4) != 0;
        }
        if (object instanceof Comment) {
            return (this.filterMask & 8) != 0;
        }
        if (object instanceof ProcessingInstruction) {
            return (this.filterMask & 0x10) != 0;
        }
        if (object instanceof EntityRef) {
            return (this.filterMask & 0x20) != 0;
        }
        if (object instanceof Document) {
            return (this.filterMask & 0x40) != 0;
        }
        return false;
    }

    public void setCDATAVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 2) : (this.filterMask &= 0xFFFFFFFD);
    }

    public void setCommentVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 8) : (this.filterMask &= 0xFFFFFFF7);
    }

    public void setDefaultMask() {
        this.filterMask = 127;
    }

    public void setDocumentContent() {
        this.filterMask = 25;
    }

    public void setElementContent() {
        this.filterMask = 63;
    }

    public void setElementVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 1) : (this.filterMask &= 0xFFFFFFFE);
    }

    public void setEntityRefVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 0x20) : (this.filterMask &= 0xFFFFFFDF);
    }

    public void setFilterMask(int n) {
        this.setDefaultMask();
        this.filterMask &= n;
    }

    public void setPIVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 0x10) : (this.filterMask &= 0xFFFFFFEF);
    }

    public void setTextVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 4) : (this.filterMask &= 0xFFFFFFFB);
    }
}

