/*
 * Copyright (c) 2001-2002, Marco Hunsicker. All rights reserved.
 *
 * This software is distributable under the BSD license. See the terms of the
 * BSD license in the documentation provided with this software.
 */
package de.hunsicker.jalopy.printer;

import java.io.IOException;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaTokenTypes;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;


/**
 * Printer for creator constructs [<code>LITERAL_new</code>].
 *
 * @author <a href="http://jalopy.sf.net/contact.html">Marco Hunsicker</a>
 * @version $Revision: 1.3 $
 */
final class CreatorPrinter
    extends AbstractPrinter
{
    //~ Static variables/initializers ----------------------------------------------------

    /** Singleton. */
    private static final Printer INSTANCE = new CreatorPrinter();

    //~ Constructors ---------------------------------------------------------------------

    /**
     * Creates a new CreatorPrinter object.
     */
    private CreatorPrinter()
    {
    }

    //~ Methods --------------------------------------------------------------------------

    /**
     * Returns the sole instance of this class.
     *
     * @return the sole instance of this class.
     */
    public static final Printer getInstance()
    {
        return INSTANCE;
    }


    /**
     * {@inheritDoc}
     */
    public void print(
        AST        node,
        NodeWriter out)
      throws IOException
    {
        printCommentsBefore(node, out);

        out.print(NEW_SPACE, JavaTokenTypes.LITERAL_new);

        for (AST child = node.getFirstChild(); child != null;
            child = child.getNextSibling())
        {
            switch (child.getType())
            {
                case JavaTokenTypes.OBJBLOCK :
                	boolean save = out.state.anonymousInnerClass;
                    out.state.anonymousInnerClass = true;

                    JavaNode n = (JavaNode) node;

                    switch (n.getParent().getParent().getType())
                    {
                        // if the creator starts an anonymous inner class and
                        // is part of another creator or method call, we have
                        // to adjust the parentheses nesting level because the
                        // indentation printing depends on this setting and
                        // would indent one level to much if left alone
                        case JavaTokenTypes.ELIST :
                            out.indent();
                            out.state.paramLevel--;
                            PrinterFactory.create(child).print(child, out);
                            out.unindent();
                            out.state.paramLevel++;

                            break;

						case JavaTokenTypes.LITERAL_return :
						// This code might be nice to have, but it yields something
						// that disagrees with Emacs.  Emacs wins...
//						{
//							boolean treatDifferent =
//									this.settings.getBoolean(
//											ConventionKeys.BRACE_TREAT_DIFFERENT,
//											ConventionDefaults.BRACE_TREAT_DIFFERENT);
//							if (treatDifferent)
//								out.unindent();
//							PrinterFactory.create(child).print(child, out);
//							if (treatDifferent)
//								out.indent();
//							break;
//						}

                        case JavaTokenTypes.ASSIGN :
                            PrinterFactory.create(child).print(child, out);

                            break;

                        default :
                            out.indent();
                            PrinterFactory.create(child).print(child, out);
                            out.unindent();
System.err.println("val=" + n.getParent().getParent().getType());
                            break;
                    }

                    out.state.anonymousInnerClass = save;

                    // hint for correct blank lines behaviour
                    out.last = JavaTokenTypes.CLASS_DEF;

                    break;

                default :
                    PrinterFactory.create(child).print(child, out);

                    break;
            }
        }
    }
}
