/*
 * tools/lib/pv_check_active.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Sistina Software
 *
 * March 1997
 * January 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    31/01/2000 - use debug_enter()/debug_leave()
 *
 */

#include <liblvm.h>

int pv_check_active ( char *vg_name, char *pv_name) {
   int ret = UNDEF;
   pv_t *pv = NULL;

#ifdef DEBUG
   debug_enter ( "pv_check_active -- CALLED\n");
#endif

   if ( vg_name == NULL || vg_check_name ( vg_name) < 0 ||
        pv_name == NULL || pv_check_name ( pv_name) < 0)
      ret = -LVM_EPARAM;
   else if ( ( ret = pv_status ( vg_name, pv_name, &pv)) == 0) {
      if ( pv->pv_status == PV_ACTIVE) ret = TRUE;
      else                             ret = FALSE;
   }

#ifdef DEBUG
   debug_leave ( "pv_check_active -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}


int pv_check_active_in_all_vg ( char *pv_name) {
   int ret = FALSE;
   int v = 0;
   char vg_name[NAME_LEN];

#ifdef DEBUG
   debug_enter ( "pv_check_active_in_all_vg -- CALLED\n");
#endif

   if ( pv_name == NULL || pv_check_name ( pv_name) < 0)
      ret = -LVM_EPARAM;
   else {
      for ( v = 0; v < ABS_MAX_VG; v++) {
         sprintf ( vg_name, "vg%02d%c", v, 0);
         if ( pv_check_active ( vg_name, pv_name) == TRUE) ret = TRUE;
      }
   }

#ifdef DEBUG
   debug_leave ( "pv_check_active_in_all_vg -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
