// Please see the README file or the LEGAL NOTES-section in the manual before modifying, compiling or using 'xmrm'
//   Idea: Manfred Kopp
//   Programming: Gerhard Waldhr, Andreas Artmann

#include <forms.h>
#include "const.h"
#include "morphvec.h"
#include "init.h"
#include "areas.h"

extern FL_OBJECT *obj_a;
extern WindowClass *a_win;
extern PictureClass *s_pic;
extern MyImageClass *MyImage;


/* Class AreaClass */

extern AreaClass *area;

/* Constructor:        */
AreaClass::AreaClass()
{
  area_buff=NULL;
}

/* Destructor:        */
AreaClass::~AreaClass()
{
  free(area_buff);
}

/* Method: InitMem */
int AreaClass::InitMem(int w,int h)
{
  // Allocating or reallocating memory for area:
  if (area_buff == NULL) 
  {
    if ( (area_buff = (unsigned char *)malloc(w*h*sizeof(unsigned char))) == NULL )
    {
      fl_show_alert("ERROR:","malloc() returned NULL !","Aborting..." ,1);
      return -1;
    }
  }
  else 
  {
    if ( (area_buff = (unsigned char *)realloc(area_buff, w*h*sizeof(unsigned char))) == NULL )
    {
      fl_show_alert("ERROR:","malloc() returned NULL !","Aborting..." ,1);
      return -1;
    }
  }

  return 0;
}

/* Method: GetPicPointer */
unsigned char *AreaClass::GetPicPointer()
{
  return area_buff;
}

/* Method: SetPicPointer */
void AreaClass::SetPicPointer(unsigned char *area_ptr)
{
  area_buff=area_ptr;
}

/* obj_a - objecthandler: Redraws area edit image */
int obj_a_handler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, int key, void *xev)
{
  a_win->SetWin();

  switch (event)
  {
    case FL_DRAW:
      if ( (s_pic->GetPicPointer() != NULL) && (area->GetPicPointer() != NULL) )
      {
        MyImage->InitImage(obj->w,obj->h);            
        MyImage->MapArea(obj,s_pic,area->GetPicPointer());
        MyImage->ShowImage(obj,a_win->GetWin());
      }
      
      break;
      
    default:
      ;
  }

  return 0;
} 

