// Please see the README file or the LEGAL NOTES-section in the manual before modifying, compiling or using 'xmrm'
//   Idea: Manfred Kopp
//   Programming: Gerhard Waldhr, Andreas Artmann

#include <forms.h>
#include "const.h"

struct Pixel
{
  unsigned char c[4];
};

struct Pixel2
{
  int c[4];
};

struct DeepCol
{
  float c[4];
};

class PictureClass
{
  unsigned long *pic;
  int pic_x, pic_y;
  
  public:

  PictureClass();
  ~PictureClass();  
 
  int InitMem();
  void SetPicSize(int x, int y);
  void GetPicSize(int *x, int *y);
  unsigned long *GetPicPointer();
  void SetPicPointer(unsigned long *pic_ptr);
};

class MyImageClass
{
  char *pic_scal;
  XImage *image;

  public:
  int image_x,image_y;
  
  MyImageClass();
  ~MyImageClass();
  int InitImage(int x,int y);
  XImage *GetImage();
  void ShowImage(FL_OBJECT *obj, Window win);
  void MapPicture(FL_OBJECT *obj, PictureClass *pic_class);
  void MapArea(FL_OBJECT *obj, PictureClass *pic_class, unsigned char *raster);
  unsigned long *RemapPicture(FL_OBJECT *obj);
};

class MorphVecClass
{
  double xa[MAX_VEC+4],ya[MAX_VEC+4],xe[MAX_VEC+4],ye[MAX_VEC+4]; // Array for vector coordinates (+4 border vektors)
  int connect[MAX_VEC+4]; // vector-connection flag: 1 if vector-end is connected, 0 if not
  int nr_vec; // number of vectors
 
  public:
  
  MorphVecClass();
  int NewVec(FL_OBJECT *obj,int nxa,int nya,int nxe,int nye,int con);
  void DelVec(int item);                              
  void RepVec(FL_OBJECT *obj,int rxa,int rya,int rxe,int rye,int item);  
  void NormVec();
  void DeNormVec();
  int SearchVec(FL_OBJECT *obj,int sx,int sy,int *flag_found);                        
  int GetMaxVec();
  void SetMaxVec(int items);
  void GetVec(FL_OBJECT *obj,int *gxa, int *gya, int *gxe, int *gye, int i);
  void GetVecArray(double **gxa, double **gya, double **gxe, double **gye);
  int GetCon(int item);
  void GetConArray(int **con);
  void DrawVector(int xa,int ya, int xe, int ye, int mode, FL_COLOR col);
  void DrawVectorScal(FL_OBJECT *obj,int item,int mode, FL_COLOR col);
  void MapVectors(FL_OBJECT *obj,int exept1, int exept2);  
};

