// Please see the README file or the LEGAL NOTES-section in the manual before modifying, compiling or using 'xmrm'
//   Idea: Manfred Kopp
//   Programming: Gerhard Waldhr, Andreas Artmann
//
// Old program-code fragments, maybe used later again...

//-----------------------------------------------------------------------------

double Interpol_Bias(int levels, double level_count, double t)
{
  double basis;
  
  basis = control.slider_bias + ( (level_count/levels) * (0.5 - control.slider_bias)*2 );

  return Bias(t,basis);
}

//-----------------------------------------------------------------------------

void MipMapArea(unsigned char *w_area)
{
  int h,w,i,j,row,col,half,ug;
  unsigned long adr,ii;
  unsigned char med;
  
  w=max_x; h=max_y;
 
  while ( (w>MIN_DECOMP) && (h>MIN_DECOMP) )
  {
    for (row=0; row<h; row++)
    {
      half = w>>1;
      ug = w & 1;
      ii=row*max_x;      
      adr=row*max_x;      

      for (i=0; i<half; i++)
      {
        w_area[adr] = ((int)w_area[ii]+(int)w_area[ii+1]) >> 1;
        ii+=2; adr++;
      }
      if (ug) w_area[adr]=w_area[ii];
      
      adr=row*max_x; j=0;
      for (i=half+ug; i<w; i++) 
      {
        w_area[adr+i]=w_area[adr+j];
        j++;
      }
    }
    w = (w>>1)+ug;

    for (col=0; col<w; col++)
    {
      ii = col; adr=col;
      half = h>>1;
      ug = h & 1;
      
      for (i=0; i<half; i++)
      {
        w_area[adr] = ((int)w_area[ii]+(int)w_area[ii+max_x]) >> 1;
        ii+=2*max_x; adr+=max_x;
      }
      if (ug) w_area[adr]=w_area[ii];
      
      adr=col; j=0;
      for (i=half+ug; i<h; i++)
      {
        w_area[adr+i*max_x]=w_area[adr+j];
        j+=max_x;
      }
    }
    
    h = (h>>1)+ug;
  }
}

//-----------------------------------------------------------------------------

/*
  // No Bilinear Interpolation:
  Rx = Xx + (long) (DSUMx / weightsum); Ry = Xy + (long) (DSUMy / weightsum);
  if ((Rx<0) || (Rx>=max_x) || (Ry<0) || (Ry>=max_y))
  {
    color_l=0;
  }
  else
  {
    adr_src = (unsigned long)Ry * max_x + (unsigned long)Rx;
    color_l = src_pic[adr_src];
  }
  for (i=0; i<4; i++) warped_pic[adr_result].c[i] = (int)((color_l & (0xff<<(i*8))) >> (i*8));
*/

//-----------------------------------------------------------------------------

/* Only for test purposes:

void Wavelet()
{
  int i,j;
  int wave_w[MAX_LEVELS],wave_h[MAX_LEVELS],levels;
  Pixel *warp_ptr;
  unsigned long color;

  result_pic->SetPicSize(max_x,max_y); result_pic->InitMem();            
  warp_ptr = (Pixel*)malloc(max_x*max_y*sizeof(Pixel));
  
  for (j=0; j<(max_x*max_y); j++)
  {
    color = s_pic->GetPicPointer()[j];

    for (i=0; i<4; i++)
      warp_ptr[j].c[i] = (int)((color & (0xff<<(i*8))) >> (i*8));        
  }
  
  Decompose(warp_ptr,wave_w,wave_h,&levels);
  Wavelet_Cross_Disolve(warp_ptr,warp_ptr,0.5,wave_w,wave_h,levels);

/////////////  
  for (j=0; j<(max_x*max_y); j++)
  {
    color = (((unsigned long)warp_ptr[j].c[0])>>0);
    for (i=1; i<4; i++)
      color = color | ((((unsigned long)warp_ptr[j].c[i])<<((i*8)-0))&(0xff<<(i*8)));    

    result_pic->GetPicPointer()[j] = color;
  }
  fl_redraw_object(obj_m);
  fl_show_message("","","");
/////////////

  Compose(warp_ptr,wave_w,wave_h,levels);

  for (j=0; j<(max_x*max_y); j++)
  {
    color=0;
    for (i=0; i<4; i++)
      color = color | ((((unsigned long)warp_ptr[j].c[i])<<(i*8))&(0xff<<(i*8)));

    result_pic->GetPicPointer()[j] = color;
  }


  fl_redraw_object(obj_m);
  
  free(warp_ptr);
}
*/

