/* vim: set sw=8 ts=8 si : */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License.
 * See http://www.gnu.org/copyleft/ for details.
 *
 * Written by Katja Socher <katja@linuxfocus.org> 
 *         and Guido Socher <guido@linuxfocus.org>
 *         
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <math.h>
#include <signal.h>
  
#include "robi.h"

/* ----------- */
static int opt_r=0;
static int fd=0;
/* ----------- */
/* ----------- */
void help()
{
	printf("pprobi -- control software for a walking robot\n\
USAGE: pprobi [-h] [parport-device]\n\
\n\
OPTIONS:\n\
         -h this help\n\
         -r reset the parallel port data pins (all zero) and exit\n\
	 \n\
The default device is /dev/parport0 \n\
");
#ifdef VERINFO
	puts(VERINFO);
#endif	 
exit(0); 
}
/* Signal handler: all off then exit */
void offandexit(int code)
{
	robi_setdata(fd,0);
	set_terminal(0);
	exit(0);
}

/* ----------- */
int main(int argc, char **argv)
{
	int state,bpat,alternate;
	char *dev;
	/* The following things are used for getopt: */
	int ch;
        extern char *optarg;
        extern int optind;
        extern int opterr;

	opterr = 0;
	while ((ch = (char)getopt(argc, argv, "hr")) != -1) {
		switch (ch) {
		case 'h':
			help(); /*no break, help does not return */
		case 'r':
			opt_r=1;
			break;
		case '?':
			fprintf(stderr, "serialtemp ERROR: No such option. -h for help.\n");
			exit(1);
		/*no default action for case */
		}
	}
	if (argc-optind < 1){
		/* less than one argument */
		dev="/dev/parport0";
	}else{
		/* the user has provided one argument */
		dev=argv[optind];
	}
	fd=robi_claim(dev); /* robi_claim has its own error checking */
	/* catch signals INT and TERM and switch off all data lines before
	 * terminating */
	signal(SIGINT, offandexit);
	signal(SIGTERM, offandexit);

	/* initialize parpprt data lines to zero: */
	robi_setdata(fd,0);
	set_terminal(1); /* set_terminal has its own error handling */ 
	state=0;
	alternate=0;
	if (opt_r){
		offandexit(1);
	}
        while(1){
		ch=getchoice();
		if (ch!=0) state=ch;
		if (ch == ' '){
			printf("Stop\n");
			robi_setdata(fd,0);
			usleep(500*1000);
		}
		if (ch == 'q'|| ch == 'x'){
			printf("Quit\n");
			break;
		}

		if (state=='l'){
			/*right */
			printf("walking right\n");
			walkright(fd);
		}
		if (state=='h'){
			/*left */
			printf("walking left\n");
			walkleft(fd);
		}
		if (state=='j'){
			printf("walking back\n");
			walkback(fd);
		}
		if (state=='k'){
			if (alternate){
				printf("walking straight on a\n");
				walkstraight_a(fd);
			}else{
				printf("walking straight on b\n");
				walkstraight_b(fd);
			}
			alternate=(alternate +1) %2;
		}

	}
	/* we get here if q was typed */
	set_terminal(0);
	return (0);
}
/* ----------- */
