#include <FL/Fl.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <FL/fl_draw.H>

#include <FL/Fl_Value_Slider.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Return_Button.H>

#include <FL/Fl_Round_Button.H>

#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Choice.H>

#include <FL/Fl_Progress.H>


/* 
 * DemoDlg
 */
class CDemoDlg : public Fl_Window
{
public:
	CDemoDlg();
	virtual ~CDemoDlg();
protected:
	/* controls */
	Fl_Return_Button *m_pApply;
	Fl_Button *m_pCancel;
	Fl_Group *m_pGroup1;
	Fl_Box *m_pText;
	Fl_Round_Button *m_pRadio1;
	Fl_Round_Button *m_pRadio2;
	Fl_Check_Button *m_pCheck1;
	Fl_Check_Button *m_pCheck2;
	Fl_Check_Button *m_pCheck3;
	Fl_Group *m_pGroup2;
	Fl_Input *m_pInput;
	Fl_Choice *m_pChoice;
	Fl_Progress *m_pProgress;

};


CDemoDlg::CDemoDlg() : Fl_Window(270, 220)
{
  	size_range(50,50,500,400);
	label("DemoDlg");

    	m_pApply = new Fl_Return_Button(135, 180, 85, 25, "Apply");
    	m_pCancel = new Fl_Button(40, 180, 85, 25, "Cancel");

	/* group 1 */
	m_pGroup1 = new Fl_Group(10, 20, 115, 150, "Group");
      	m_pGroup1->box(FL_ENGRAVED_FRAME);
      	m_pGroup1->align(FL_ALIGN_TOP_LEFT);

	m_pText = new Fl_Box(5, 25, 100, 25, "Simple Text");
	m_pText->align(FL_ALIGN_WRAP);

	m_pRadio1 = new Fl_Round_Button(15, 50, 100, 25, "Radio1");
	m_pRadio1->down_box(FL_ROUND_DOWN_BOX);

	m_pRadio2 = new Fl_Round_Button(15, 70, 100, 25, "Radio2");
	m_pRadio2->down_box(FL_ROUND_DOWN_BOX);

	m_pCheck1 = new Fl_Check_Button(15, 95, 100, 25, "Check1");
	m_pCheck1->down_box(FL_DOWN_BOX);

	m_pCheck2 = new Fl_Check_Button(15, 115, 100, 25, "Check2");
	m_pCheck2->down_box(FL_DOWN_BOX);

	m_pCheck3 = new Fl_Check_Button(15, 135, 100, 25, "Check3");
	m_pCheck3->down_box(FL_DOWN_BOX);

	/* group 2 */
	m_pGroup2 = new Fl_Group(140, 20, 115, 150, "Group");
      	m_pGroup2->box(FL_ENGRAVED_FRAME);
      	m_pGroup2->align(FL_ALIGN_TOP_LEFT);

	m_pInput = new Fl_Input(145, 40, 100, 25, "Input");
	m_pInput->align(FL_ALIGN_TOP_LEFT);
	m_pInput->value("Test");

	m_pChoice = new Fl_Choice(145, 85, 100, 25, "Choice");
	m_pChoice->down_box(FL_BORDER_BOX);
	m_pChoice->align(FL_ALIGN_TOP_LEFT);

	m_pProgress = new Fl_Progress(145, 130, 100, 25, "Progress");
	m_pProgress->align(FL_ALIGN_TOP_LEFT);
	m_pProgress->maximum(100.0);
	m_pProgress->minimum(0.0);
	m_pProgress->value(75.0);
  
	end();
  	///show();
}


CDemoDlg::~CDemoDlg()
{
	/* TODO: */
}


/*
 * Main
 */
void CallbackQuit(Fl_Widget*, void*) 
{
	exit(0);
}


void CallbackShowDialog(Fl_Widget* pDlg, void*) 
{
	CDemoDlg *pDemoDlg = new CDemoDlg;

	pDemoDlg->show();
}


Fl_Menu_Item g_menuTable[] = 
{
	{"&File",0,0,0,FL_SUBMENU},
    		{"&Open",	FL_ALT+'o', 0, 0, FL_MENU_INACTIVE},
    		{"&Close",	0,	0},
    		{"&Quit",	FL_ALT+'q', CallbackQuit},
    		{0},
  	{"&Demo",FL_F+2,0,0,FL_SUBMENU},
    		{"Show DemoDlg",	FL_ALT+'z', CallbackShowDialog},
    		{"Redo",	FL_ALT+'r',	0, 0, FL_MENU_DIVIDER},
    		{"Cut",	FL_ALT+'x',	0},
    		{"Copy",	FL_ALT+'c',	0},
    		{"Paste",	FL_ALT+'v',	0},
    		{"Inactive",FL_ALT+'d',	0, 0, FL_MENU_INACTIVE},
    		{"Clear",	0,	0, 0, FL_MENU_DIVIDER},
    		{"Invisible",FL_ALT+'e',	0, 0, FL_MENU_INVISIBLE},
    		{"Preferences",0,	0},
    		{"Size",	0,	0},
    		{0},
  	{"&Help",FL_F+3,0,0,FL_SUBMENU},
    		{0},
  	{0}
};
 


int main(int argc, char **argv) 
{
  	Fl_Window wndMain(600, 400);
  	Fl_Menu_Bar menuMain(0,0,600,30); 

  	menuMain.menu(g_menuTable);
  	wndMain.size_range(300,400,0,400);
  	wndMain.label("DemoApp");
  	wndMain.end();
  	wndMain.show(argc, argv);

  	return Fl::run();
}

